
/*
 * Copyright (c) Abraham vd Merwe <abz@blio.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of other contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stddef.h>
#include <string.h>

#include <debug/memory.h>
#include <abz/error.h>
#include <abz/trim.h>
#include <abz/tokens.h>

void tokens_destroy (struct tokens *tokens)
{
   int i;

   for (i = 0; i < tokens->argc; i++)
	 mem_free (tokens->argv[i]);

   if (tokens->argv != NULL)
	 mem_free (tokens->argv);
}

int tokens_parse (struct tokens *tokens,const char *str)
{
   int i,gotstr = 0;
   const char *prev = str;
   void *tmp;

   abz_clear_error ();

   tokens->argv = NULL;
   tokens->argc = 0;

   do
	 {
		if ((tmp = mem_realloc (tokens->argv,(tokens->argc + 1) * sizeof (char *))) == NULL ||
			(((char **) tmp)[tokens->argc] = (char *) mem_alloc ((strlen (prev) + 1) * sizeof (char))) == NULL)
		  {
			 abz_set_error ("memory allocation failed: %m");
			 tokens_destroy (tokens);
			 return (-1);
		  }

		tokens->argv = (char **) tmp;
		strcpy (tokens->argv[tokens->argc],prev);
		ltrim (tokens->argv[tokens->argc]);

		if (!gotstr && tokens->argv[tokens->argc][0] != '"')
		  {
			 if ((prev = strchr (tokens->argv[tokens->argc],' ')) != NULL ||
				 (prev = strchr (tokens->argv[tokens->argc],'"')) != NULL ||
				 (prev = strchr (tokens->argv[tokens->argc],'\t')) != NULL)
			   {
				  gotstr = *prev == '"';
				  *(char *) prev++ = '\0';
				  ltrim ((char *) prev);
			   }
		  }
		else
		  {
				char *s;
				char *d;
				s = d = tokens->argv[tokens->argc];
				if (!gotstr)
				{
					++d;
				}
				while (*d != '\0' && *d != '"')
				{
					if (*d == '\\')
					{
						++d;
						if (*d == '\0')
						{
							break;
						}
					}
					*s++ = *d++;
				}

			 if (*d == '\0')
			   {
				  abz_set_error ("missing \" at end of fo string");
				  tokens->argc++;
				  tokens_destroy (tokens);
				  return (-1);
			   }

			 *s++ = '\0';
			 ++d;
			 prev = *d != '\0' ? d : NULL;
			 gotstr = 0;
		  }
		tokens->argc++;
	 } while (prev != NULL);

   for (i = 0; i < tokens->argc; i++)
	 if ((tmp = mem_realloc (tokens->argv[i],(strlen (tokens->argv[i]) + 1) * sizeof (char))) != NULL)
	   tokens->argv[i] = (char *) tmp;

   return (0);
}

