/*
 * arpping.c
 *
 * Mostly stolen from: dhcpcd - DHCP client daemon
 * by Yoichi Hariguchi <yoichi@fore.com>
 */

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
//#include <netinet/if_ether.h>
#include <net/if_arp.h>
#include <netinet/in.h>

#include <netpacket/packet.h>
#include <net/ethernet.h>

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <unistd.h>
#include <fcntl.h>
#include <stddef.h>

#include "dhcpd.h"
#include "debug.h"
#include "arpping.h"

static int sock = -1;
static in_addr_t our_ip;
static unsigned char our_mac[ETH_ALEN];
static int our_ifindex;

void arp_shutdown(void)
{
    if (sock != -1)
    {
        close(sock);
        sock = -1;
    }
}

int arp_init(in_addr_t ip, unsigned char *mac, int ifindex)
{
    int optval = 1;
    struct sockaddr_ll source_addr;

    arp_shutdown();

    memset(&source_addr, 0, sizeof(source_addr));
    source_addr.sll_family = AF_PACKET;
    source_addr.sll_protocol = htons(ETH_P_ARP);
    source_addr.sll_ifindex = ifindex;

    if ((sock = socket (PF_PACKET, SOCK_RAW, htons(ETH_P_ARP))) == -1)
    {
        LOG(LOG_ERR, "Could not open raw socket");
    }
    else if (bind (sock, (struct sockaddr *) &source_addr, sizeof (source_addr)) < 0)
    {
        LOG(LOG_ERR, "Could not bind raw socket.");
        close(sock);
        return -1;
    }
    else if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &optval, sizeof(optval)) == -1)
    {
        LOG(LOG_ERR, "Could not setsocketopt on raw socket");
        close(sock);
        sock = -1;
    }
    else
    {
        our_ip = ip;
        memcpy(our_mac, mac, sizeof(our_mac));
        our_ifindex = ifindex;
    }
    return sock;
}

int arp_ping( in_addr_t ip )
{
    struct arpMsg arp;
    int retval;
    struct sockaddr_ll source_addr;

    if (ip == our_ip)
    {
        DEBUG(LOG_INFO, "It is our address.");
        return -1;
    }
    if (sock < 0)
    {
        LOG(LOG_ERR, "ARP Socket is uninitilized.");
        return -1;
    }
    DEBUG(LOG_INFO, "arpping(): my IP: %lx, target IP: %lx", (unsigned long)our_ip, (unsigned long)ip);

    /* send arp request */
    memset(&arp, 0, sizeof(arp));
    memcpy(arp.ethhdr.h_dest, MAC_BCAST_ADDR, ETH_ALEN);	/* MAC DA */
    memcpy(arp.ethhdr.h_source, our_mac, ETH_ALEN);		/* MAC SA */
    arp.ethhdr.h_proto = htons(ETH_P_ARP);		/* protocol type (Ethernet) */
    arp.htype = htons(ARPHRD_ETHER);			/* hardware type */
    arp.ptype = htons(ETH_P_IP);			/* protocol type (ARP message) */
    arp.hlen = ETH_ALEN;				/* hardware address length */
    arp.plen = sizeof(ip);				/* protocol address length */
    arp.operation = htons(ARPOP_REQUEST);		/* ARP op code */
    arp.sInaddr = our_ip;				/* source IP address */
    memcpy(arp.sHaddr, our_mac, ETH_ALEN);		/* source hardware address */
    arp.tInaddr = ip;					/* target IP address */

    memset(&source_addr, 0, sizeof(source_addr));
    source_addr.sll_family = AF_PACKET;
    source_addr.sll_protocol = htons(ETH_P_ARP);
    source_addr.sll_ifindex = our_ifindex;
    do
    {
        retval = sendto(sock, &arp, sizeof(arp), 0, (struct sockaddr *)&source_addr, sizeof(source_addr));
    }
    while ( retval < 0 && errno == EINTR );
    return retval;
}

/*
 * fills p_ip and mac values on valid arp reply
 * @return
 * -1 on error, no more tries.
 * 0 no valid data, can try for more.
 * > 0 - valid response data, is available, can try for more.
 *
 */
int arp_handle( in_addr_t* p_ip, unsigned char* mac )
{
    struct arpMsg arp;
    int retval;
    do
    {
        retval = recv(sock, &arp, sizeof(arp), MSG_DONTWAIT);
    }
    while (retval < 0 && errno == EINTR );

    if ( retval < 0 )
    {
        /* error occured, can be also EAGAIN */
        return -1;
    }
    if ( retval < (int)offsetof(struct arpMsg, pad) )
    {
        /* packet corrupted */
        return 0;
    }
    if (
        arp.operation != htons(ARPOP_REPLY) ||
        arp.tInaddr != our_ip ||
        memcmp(arp.tHaddr, our_mac, 6) != 0
       )
    {
        /* We need only replies to our request */
        return 0;
    }
    DEBUG(LOG_INFO, "Valid arp reply receved for this address");
    *p_ip = arp.sInaddr;
    memcpy(mac, arp.sHaddr, ETH_ALEN);
    return retval;
}
