/*
 * arpping .h
 */

#ifndef ARPPING_H
#define ARPPING_H

#include <netinet/if_ether.h>
#include <net/if_arp.h>
#include <net/if.h>
#include <netinet/in.h>

struct arpMsg
{
	struct ethhdr ethhdr;	 		/* Ethernet header */
	u_short htype;				/* hardware type (must be ARPHRD_ETHER) */
	u_short ptype;				/* protocol type (must be ETH_P_IP) */
	u_char  hlen;				/* hardware address length (must be 6) */
	u_char  plen;				/* protocol address length (must be 4) */
	u_short operation;			/* ARP opcode */
	u_char  sHaddr[6];			/* sender's hardware address */
	in_addr_t  sInaddr;			/* sender's IP address */
	u_char  tHaddr[6];			/* target's hardware address */
	in_addr_t  tInaddr;			/* target's IP address */
	u_char  pad[18];			/* pad for min. Ethernet payload (60 bytes) */
} __attribute__ ((packed));

/* new asynch functions prototypes */
void arp_shutdown(void);
int arp_init(in_addr_t ip, unsigned char *mac, int ifindex);
int arp_ping( in_addr_t ip );
int arp_handle( in_addr_t* p_ip, unsigned char* mac );

#endif
