/* leases.h */
#ifndef _LEASES_H
#define _LEASES_H

#include "packet.h"
#include <sys/time.h>

struct dhcpDiscoverData
{
    struct timeval      timestamp;
    struct dhcpMessage  packet;
} __attribute__ ((packed));

struct dhcpOfferedAddr
{
    u_int8_t chaddr[16];
    u_int32_t yiaddr;	/* network order */
    u_int32_t expires;	/* host order */
    struct dhcpDiscoverData* discovery;
} __attribute__ ((packed));

extern const unsigned char blank_chaddr[];

void clear_lease(const u_int8_t *chaddr, u_int32_t yiaddr);
struct dhcpOfferedAddr *add_lease(const u_int8_t *chaddr, u_int32_t yiaddr, unsigned long lease);
int lease_expired(const struct dhcpOfferedAddr *lease);
struct dhcpOfferedAddr *oldest_expired_lease(void);
struct dhcpOfferedAddr *find_lease_by_chaddr(const u_int8_t *chaddr);
struct dhcpOfferedAddr *find_lease_by_yiaddr(u_int32_t yiaddr);
u_int32_t find_address(int check_expired);
int check_ip(u_int32_t addr);


#endif
