.PHONY: wifidog wifidog-install wifidog-clean

wifidog_cflags = ${build_cflags} -Os
wifidog_target_dir = ${build_install_directory}/sbin
wifidog_ldflags = ${build_ldflags}

wifidog/.configured:
	( cd wifidog && touch configure && rm -f config.cache && \
	  LIBS="${build_toolchain_dir}/usr/lib/libpthread.a" \
	  LDFLAGS="${wifidog_ldflags}" \
	  CFLAGS="${wifidog_cflags}" \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  LD="${build_toolchain_prefix}ld" \
	  CXX="${build_toolchain_prefix}g++" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  PREFIX=${build_install_directory} \
	  EPREFIX=${build_install_directory} \
	  ./configure --prefix= \
	  --host=mips-linux \
	  --build=i686-linux \
	  --disable-doxygen \
	  --disable-dot \
	  --disable-html-docs \
	  --disable-latex-docs \
	  --without--pic \
	  --disable-shared \
         && touch .configured)


wifidog: wifidog/.configured
	$(MAKE) -C wifidog

wifidog-clean:
	rm -f wifidog/.configured	
	$(MAKE) -C wifidog distclean || echo "Ignoring errors"

wifidog-install: wifidog
	cp -f wifidog/src/wifidog $(wifidog_target_dir)/wifidog
	$(STRIP) $(wifidog_target_dir)/wifidog
