.PHONY: wpasupplicant-0.6.3 wpasupplicant-0.6.3-clean \
	wpasupplicant-0.6.3-install

WPASUPPLICANT_0_6_3_DIR = wpa_supplicant-0.6.3/wpa_supplicant

WPASUPPLICANT_0_6_3_CFLAGS = -Os -Wall -Wstrict-prototypes \
	-I${BUILDDIR}/drivers/madwifi-5.0 \
	-DCONFIG_NO_IFACE_DOWN_CONTROL \
	-DCONFIG_NO_AUTO_AUTH_ALG_SELECT
	
WPASUPPLICANT_0_6_3_MAKE_ENV= \
	CC=$(build_toolchain_prefix)gcc \
	CONFIG_DRIVER_WEXT=y \
	CONFIG_DRIVER_MADWIFI=y \
	CONFIG_EAP_TTLS=y \
	CONFIG_EAP_MSCHAPV2=y \
	CONFIG_TLS=internal \
	CONFIG_INTERNAL_LIBTOMMATH=y \
	CONFIG_EAP_PEAP=y \
	CONFIG_EAP_TLS=y \
	CONFIG_EAP_LEAP=y

#	CONFIG_PRIVACY_CONTROL=y - TODO: will need patchfor this..
#   Test for privacy first, changeset was [2411]

#	CONFIG_ROAMING_CONTROL=y - TODO: will need patchfor this..
#   Test for this first, changeset was [2387]

$(WPASUPPLICANT_0_6_3_DIR)/.patched:
	@for i in $(WPASUPPLICANT_0_6_3_DIR)/patches/*; do \
		echo "[PATCH] Applying: $$i" ; \
		patch -p1 -N -s -d $(WPASUPPLICANT_0_6_3_DIR)/.. < $$i || exit 1; \
	done
	@touch $(WPASUPPLICANT_0_6_3_DIR)/.patched

wpasupplicant-0.6.3: $(WPASUPPLICANT_0_6_3_DIR)/.patched
	rm -f $(WPASUPPLICANT_0_6_3_DIR)/.config
	touch $(WPASUPPLICANT_0_6_3_DIR)/.config
	CFLAGS="$(WPASUPPLICANT_0_6_3_CFLAGS)" \
		$(MAKE) -C $(WPASUPPLICANT_0_6_3_DIR) $(WPASUPPLICANT_0_6_3_MAKE_ENV) \
		wpa_supplicant

wpasupplicant-0.6.3-clean:
	$(MAKE) -C $(WPASUPPLICANT_0_6_3_DIR) $(WPASUPPLICANT_0_6_3_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	@for i in $(WPASUPPLICANT_0_6_3_DIR)/patches/*; do \
		echo "[PATCH] Reversing: $$i" ; \
		patch -p1 -R -N -r /dev/null -s -d $(WPASUPPLICANT_0_6_3_DIR)/.. < $$i \
			|| echo "Ignoring errors!"; \
	done
	rm -f $(WPASUPPLICANT_0_6_3_DIR)/.patched
	
wpasupplicant-0.6.3-install: wpasupplicant-0.6.3
	cp -f $(WPASUPPLICANT_0_6_3_DIR)/wpa_supplicant ${build_install_directory}/bin/
	${build_toolchain_prefix}strip ${build_install_directory}/bin/wpa_supplicant
	# leave code as it was. Unpatch it after install
	@for i in $(WPASUPPLICANT_0_6_3_DIR)/patches/*; do \
		echo "[PATCH] Reversing: $$i" ; \
		patch -p1 -R -N -r /dev/null -s -d $(WPASUPPLICANT_0_6_3_DIR)/.. < $$i \
			|| echo "Ignoring errors!"; \
	done
	rm -f $(WPASUPPLICANT_0_6_3_DIR)/.patched
