.PHONY: wpasupplicant-openssl-static wpasupplicant-openssl-static-clean wpasupplicant-openssl-static-install

CFLAGS = -Os -Wall -Wstrict-prototypes \
	-I${BUILDDIR}/apps/open/openssl/include
LDFLAGS= -L${BUILDDIR}/apps/open/openssl -ldl
WPASUPPLICANT_OPENSSL_MAKE_ENV= CFLAGS_OVERRIDE="$(CFLAGS)" \
	LDFLAGS="$(LDFLAGS)" CROSS=$(build_toolchain_prefix) CONFIG_USE_OPENSSL=y \
	LIB_ZLIB="-L${BUILDDIR}/apps/open/zlib-1.2.3 -lz" PLATFORM=madwifi

wpasupplicant-openssl-static: wpasupplicant-openssl-static-clean
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_OPENSSL_MAKE_ENV) mkconfig
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_OPENSSL_MAKE_ENV) \
		wpa_supplicant

wpasupplicant-openssl-static-clean:
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_OPENSSL_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	$(MAKE) -C hostap/hostapd $(WPASUPPLICANT_OPENSSL_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	
wpasupplicant-openssl-static-install: wpasupplicant-openssl-static
	cp -f hostap/wpa_supplicant/wpa_supplicant ${build_install_directory}/bin/
	${build_toolchain_prefix}strip ${build_install_directory}/bin/wpa_supplicant
