.PHONY: wpasupplicant-openssl wpasupplicant-openssl-clean wpasupplicant-openssl-install

CFLAGS = -Os -Wall -Wstrict-prototypes \
	-I${BUILDDIR}/apps/open/openssl/include
LDFLAGS= -L${BUILDDIR}/apps/open/openssl
WPASUPPLICANT_OPENSSL_MAKE_ENV= CFLAGS_OVERRIDE="$(CFLAGS)" \
	LDFLAGS="$(LDFLAGS)" CROSS=$(build_toolchain_prefix) CONFIG_USE_OPENSSL=y \
	LIB_ZLIB="-L${BUILDDIR}/apps/open/zlib-1.2.3 -lz" PLATFORM=madwifi

wpasupplicant-openssl: wpasupplicant-openssl-clean
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_OPENSSL_MAKE_ENV) mkconfig
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_OPENSSL_MAKE_ENV) \
		wpa_supplicant

wpasupplicant-openssl-clean:
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_OPENSSL_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	$(MAKE) -C hostap/hostapd $(WPASUPPLICANT_OPENSSL_MAKE_ENV) clean \
		|| echo "Ignoring errors!"

wpasupplicant-openssl-install: wpasupplicant-openssl
	cp -f hostap/wpa_supplicant/wpa_supplicant ${build_install_directory}/bin/
	${build_toolchain_prefix}strip ${build_install_directory}/bin/wpa_supplicant
