.PHONY: wpasupplicant wpasupplicant-clean wpasupplicant-install

CFLAGS = -Os -Wall -Wstrict-prototypes
WPASUPPLICANT_MAKE_ENV= CFLAGS_OVERRIDE="$(CFLAGS)" \
	CROSS=$(build_toolchain_prefix) PLATFORM=madwifi

wpasupplicant: wpasupplicant-clean
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_MAKE_ENV) mkconfig
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_MAKE_ENV) wpa_supplicant

wpasupplicant-clean:
	$(MAKE) -C hostap/wpa_supplicant $(WPASUPPLICANT_MAKE_ENV) clean \
		|| echo "Ignoring errors!"
	$(MAKE) -C hostap/hostapd $(WPASUPPLICANT_MAKE_ENV) clean \
		|| echo "Ignoring errors!"

wpasupplicant-install: wpasupplicant
	cp -f hostap/wpa_supplicant/wpa_supplicant ${build_install_directory}/bin/
	${build_toolchain_prefix}strip ${build_install_directory}/bin/wpa_supplicant
