.PHONY: curl curl-clean curl-install

CURL=curl
CURL_STRIP=${build_toolchain_prefix}strip --remove-section=.comment --remove-section=.note -s

curl/.configured:
	( cd ${CURL}; \
	  CC="${build_toolchain_prefix}gcc" \
	  AR="${build_toolchain_prefix}ar" \
	  RANLIB="${build_toolchain_prefix}ranlib" \
	  ./configure \
	  --host=mips-linux \
	  --enable-thread --enable-shared \
	  --enable-http --enable-ftp \
	  --disable-file --disable-ldap \
	  --disable-dict --disable-telnet --disable-tftp --disable-manual \
	  --disable-ipv6 --disable-sspi --without-ssl --without-gnutls --without-zlib \
	  --disable-largefile --disable-verbose \
	  && touch .configured )

curl: curl/.configured
	$(MAKE) -C ${CURL}

curl-clean:
	-test -f ${CURL}/Makefile && $(MAKE) -C ${CURL} clean
	rm -f ${CURL}/.configured ${CURL}/Makefile

curl-install: curl
	mkdir -p $(build_install_directory)/lib
	cp -fd ${CURL}/lib/.libs/libcurl*.so* $(build_install_directory)/lib
	$(CURL_STRIP) $(build_install_directory)/lib/libcurl.so
#	cp -fd ${CURL}/src/.libs/curl $(build_install_directory)/bin/
#	$(CURL_STRIP) $(build_install_directory)/bin/curl
