.PHONY: openssl openssl-clean openssl-install

OPENSSL_DIR=openssl
ZLIB_DIR=$(shell pwd)/zlib-1.2.3

OPENSSL_MIPS_FLAGS:=-Os -D_FILE_OFFSET_BITS=32
OPENSSL_NO_CIPHERS:= no-idea no-md2 no-mdc2 no-rc2 no-rc5 no-sha0 \
                                        no-rmd160 no-ripemd no-camellia no-ans1 no-krb5
OPENSSL_OPTIONS:= shared zlib no-ec no-err no-hw no-threads no-asm \
                                        no-engines no-sse2 no-perlasm no-ssl2 no-ssl3 no-deprecated

$(OPENSSL_DIR)/.configured:
	(cd $(OPENSSL_DIR); \
		./Configure linux-mips \
			-DOPENSSL_SMALL_FOOTPRINT \
			$(OPENSSL_NO_CIPHERS) \
			$(OPENSSL_OPTIONS) \
			-I$(ZLIB_DIR) \
			-L$(ZLIB_DIR) \
        )
	$(MAKE) -C $(OPENSSL_DIR) \
		OPENSSL_MIPS_FLAGS="$(OPENSSL_MIPS_FLAGS)" \
		MAKEDEPPROG="${build_toolchain_prefix}gcc" \
		depend
	touch $(OPENSSL_DIR)/.configured

openssl: $(OPENSSL_DIR)/.configured
	$(MAKE) -C $(OPENSSL_DIR) \
		CC="${build_toolchain_prefix}gcc" \
		AR="${build_toolchain_prefix}ar r" \
		RANLIB="${build_toolchain_prefix}ranlib" \
		OPENSSL_MIPS_FLAGS="$(OPENSSL_MIPS_FLAGS)" \
		all build-shared
	# Work around openssl build bug to link libssl.so with libcrypto.so.
	-rm $(OPENSSL_DIR)/libssl.so.*.*.*
	$(MAKE) -C $(OPENSSL_DIR) \
		CC="${build_toolchain_prefix}gcc" \
		OPENSSL_MIPS_FLAGS="$(OPENSSL_MIPS_FLAGS)" \
		do_linux-shared

openssl-clean:
	$(MAKE) -C $(OPENSSL_DIR) clean
	rm -f $(OPENSSL_DIR)/.configured

openssl-install: openssl
	mkdir -p $(build_install_directory)/lib
	cp -fd ${OPENSSL_DIR}/libcrypto.so.0.9.8 $(build_install_directory)/lib
	cp -fd ${OPENSSL_DIR}/libssl.so.0.9.8 $(build_install_directory)/lib
	${build_toolchain_prefix}strip --remove-section=.comment --remove-section=.note -s $(build_install_directory)/lib/libcrypto.so.0.9.8
	${build_toolchain_prefix}strip --remove-section=.comment --remove-section=.note -s $(build_install_directory)/lib/libssl.so.0.9.8
