.PHONY: zlib zlib-clean zlib-install

ZLIB=zlib-1.2.3

zlib/.configured:
	( cd ${ZLIB}; CC="${build_toolchain_prefix}gcc" ./configure --shared && touch .configured )

zlib: zlib/.configured
	$(MAKE) -C ${ZLIB}

zlib-clean:
	-test -f ${ZLIB}/Makefile && $(MAKE) -C ${ZLIB} clean
	rm -f ${ZLIB}/.configured ${ZLIB}/Makefile

zlib-install: zlib
	mkdir -p $(build_install_directory)/lib
	cp -fd ${ZLIB}/libz*.so* $(build_install_directory)/lib
	${build_toolchain_prefix}strip --remove-section=.comment --remove-section=.note -s $(build_install_directory)/lib/libz.so
