#!/sbin/cgi
<?
  SecureVar("cmd*");
  SecureVar("lines");
  include("lib/settings.inc");
  $cfg = @cfg_load($cfg_file);
  include("lib/l10n.inc");
  include("lib/link.inc");
  include("lib/misc.inc");  

  if ($cfg == -1) {
	  include("lib/busy.tmpl");
	  exit;
  }

  $wmm_status = cfg_get_def($cfg, "wireless.1.wmm", "disabled");
  $level = cfg_get_def($cfg, "wireless.1.wmmlevel", "2");
  $wmode_type = get_wmode_type(cfg_get_wmode($cfg, $wlan_iface));
  $ieee_mode = cfg_get_ieee_mode($cfg, $wlan_iface, $ieee_mode);
  $ieee_mode = strtolower($ieee_mode);

  if ($REQUEST_METHOD == "POST") {
	$wmm_status = wmm_get_status($wmm_level);
	cfg_set($cfg, "wireless.1.wmm", $wmm_status);
	cfg_set($cfg, "wireless.1.wmmlevel", $wmm_level);
        $level = $wmm_level;
	set_rts_treshold($cfg, $wlan_iface, $rts, $rtsoff);
	set_frag_treshold($cfg, $wlan_iface, $frag, $fragoff);
	set_ack_distance($cfg, $wlan_iface, $ackdistance, $ieee_mode);
	set_autoack($cfg, $wlan_iface, $autoack);
  	if ($feature_super == 0)
	{
		$fast_frame = 0;
		$burst = 0;
		$compression = 0;
	}
	set_fast_frame($cfg, $wlan_iface, $fast_frame);
	set_bursting($cfg, $wlan_iface, $burst);
	set_compression($cfg, $wlan_iface, $compression);
	if ($radio1_ant_count > 1) {
		set_antenna($cfg, $wlan_iface, $antenna, $tx_antenna, $rx_antenna);
	}
	if ($feature_ratemodule == 1) {
		cfg_set($cfg, "radio.ratemodule", $rate_module);
	}
	cfg_set_signal_leds($cfg, $led1, $led2, $led3, $led4);

	if (strlen($shaper_status)){
		$shaper_status = "enabled";
		cfg_set($cfg, "tshaper.in.1.devname", $eth_iface);
		cfg_set($cfg, "tshaper.out.1.devname", $wlan_iface);
		cfg_set($cfg, "tshaper.in.rate", $in_rate);
		cfg_set($cfg, "tshaper.out.rate", $out_rate);
		if (strlen($in_burst) == 0)
		{
			$in_burst = 0;
		}
		cfg_set($cfg, "tshaper.in.burst", $in_burst);
		if (strlen($out_burst) == 0)
		{
			$out_burst = 0;
		}
		cfg_set($cfg, "tshaper.out.burst", $out_burst);
	} else {
		$shaper_status = "disabled";
	}
	cfg_set($cfg, "tshaper.status", $shaper_status);

	if (strlen($mcast_status)){
        	$mcast_status = "enabled";
        } else {
        	$mcast_status = "disabled";
        }
	if (strlen($client_isolation_status))
	{
		$client_isolation_status = "enabled";
	}
	else
	{
		$client_isolation_status = "disabled";
	}

	if (strlen($sper)) {
        	$sper = "enabled";
        } else {
        	$sper = "disabled";
        }
        
        cfg_set($cfg, "wireless.1.sper", $sper);

	if (strlen($mtikie)) {
        	$mtikie = "enabled";
        } else {
        	$mtikie = "disabled";
        }
        
        cfg_set($cfg, "wireless.1.addmtikie", $mtikie);
                
	cfg_set($cfg, "netconf.2.allmulti", $mcast_status);
	cfg_set($cfg, "radio.1.mcastrate", $mcast_rate);
	cfg_set($cfg, "wireless.1.l2_isolation", $client_isolation_status);
        
        cfg_set($cfg, "radio.1.thresh62a", $noise_immunity);
        cfg_set($cfg, "radio.1.thresh62b", $noise_immunity);
        cfg_set($cfg, "radio.1.thresh62g", $noise_immunity);

	if (strlen($ani_status)){
        	$ani_status = "enabled";
        } else {
        	$ani_status = "disabled";
        }
        cfg_set($cfg, "radio.1.ani.status", $ani_status);

        cfg_save($cfg, $cfg_file);
	cfg_set_modified($cfg_file);
        $message = dict_translate("Configuration saved");
  }

  if (!strlen($rts)) {
	$rts = "off";
  }
  $rts = cfg_get_def($cfg, "radio.1.rts", $rts);
  if (!strlen($frag)) {
	$frag = "off";
  }
  $frag = cfg_get_def($cfg, "radio.1.frag", $frag);
  $autoack = cfg_get_autoack($cfg, $wlan_iface, $autoack);
  $fast_frame = cfg_get_fast_frame($cfg, $wlan_iface, $fast_frame);
  $burst = cfg_get_bursting($cfg, $wlan_iface, $burst);
  $compression = cfg_get_compression($cfg, $wlan_iface, $compression);
  $rate_module = cfg_get_def($cfg, "radio.ratemodule", $def_rate_module);
  $wmm_options = wmm_generate_options($wmm_status, $level);
  $ani_status = cfg_get_def($cfg, "radio.1.ani.status", "disabled");

  $leds = cfg_get_leds($cfg);

  $led1 = $leds[0];
  $led2 = $leds[1];
  $led3 = $leds[2];
  $led4 = $leds[3];

  $shaper_status = cfg_get_def($cfg, "tshaper.status", "disabled");
  $in_rate = cfg_get_def($cfg, "tshaper.in.rate", "512");
  $in_burst = cfg_get_def($cfg, "tshaper.in.burst", "0");
  $out_rate = cfg_get_def($cfg, "tshaper.out.rate", "512");
  $out_burst = cfg_get_def($cfg, "tshaper.out.burst", "0");

  if ($radio1_ant_count > 1) {
	$antenna = get_antenna_diversity($cfg, $wlan_iface, $antenna);
  }

  if (strlen($noise_immunity) == 0) {
  	$noise_immunity = 28;
  }
  $noise_immunity = cfg_get_def($cfg, "radio.1.thresh62a", $noise_immunity);
  $ackdistance = cfg_get_ackdistance($cfg, $wlan_iface, $ieee_mode);
  $clksel = cfg_get_clksel($cfg, $wlan_iface, $clksel);
  $mcast_status = cfg_get_def($cfg, "netconf.2.allmulti", "disabled");
  $client_isolation_status = cfg_get_def($cfg, "wireless.1.l2_isolation", "disabled");
  $sper = cfg_get_def($cfg, "wireless.1.sper", $sper);
  $mtikie = cfg_get_def($cfg, "wireless.1.addmtikie", $mtikie);
  if (strlen($mtikie) == 0) {
  	$mtikie = "enabled";
  }  
  $mcast_rate = cfg_get_def($cfg, "radio.1.mcastrate", $mcast_rate);  
  $maxacktimeout = 204;
  $sltconst = 9;
  switch ($ieee_mode)
  {
  case "1";
  case "a";
	if ($clksel == 1)
	{
		$sltconst = 18;
		$maxacktimeout = 819; /* 20 half */
	}
	elseif ($clksel == 2)
	{
		$sltconst = 36;
  		$maxacktimeout = 1638; /* 10 quarter */
  	}
  	else
  	{
		$sltconst = 9;
	  	$maxacktimeout = 409; /* 40 */
  	}
  break;
  case "2";
  case "b";
  	$maxacktimeout = 744; /* 22 */
	$sltconst = 11;
  break;
  case "3";
  case "gt";
  case "g";
  case "pureg";
	if ($clksel == 1)
	{
		$sltconst = 17;
	  	$maxacktimeout = 744; /* 22 half */
	}
	elseif ($clksel == 2)
	{
		$sltconst = 35;
	  	$maxacktimeout = 1489; /* 11 quarter */
  	}
  	else
  	{
		$sltconst = 9;
	  	$maxacktimeout = 372; /* 44 */
	}
  break;
  case "7";
  case "ast";
  case "5";
  case "at";
	$sltconst = 4;
  	$maxacktimeout = 204; /* 80 */
  break;
  }
  $minacktimeout = $sltconst * 2 + 3;
  $acktimeout = $minacktimeout + ($ackdistance / 150); 
  /* If maximum distance limit is placed on this board, we calculate new max ack timeout based
   * on speed of light. */
  if (strlen($radio1_distance_limit_km) && $radio1_distance_limit_km != "0") {
	$speed_of_light_meters_per_microsecond = 300.0;
	$uS = ((( 2 * $radio1_distance_limit_km * 1000.0 ) / $speed_of_light_meters_per_microsecond) ) + 0.5;
	$maxacktimeout = $minacktimeout + $uS;
  }
  include("lib/advanced.tmpl");
>
