#!/sbin/cgi
<?
include("lib/settings.inc");
$cfg = @cfg_load($cfg_file);
include("lib/l10n.inc");
include("lib/link.inc");

/*
Bridge:
ebtables FORWARD -i [LAN|WLAN] -p 0x0800 --ip-src [!] address[/mask] --ip-dst [!] address[/mask] --ip-protocol [6(TCP)|17(UDP)|1(ICMP)|0(IP)] --ip-sport [!] port1[:port2] --ip-dport [!] port1[:port2] -j [DROP|ACCEPT|CONTINUE]

Router
iptables FORWARD -i [LAN|WLAN|PPP] [--protocol [6(TCP)|17(UDP)|1(ICMP)|0(IP)] | -m ipp2p --ipp2p]  --src [!] address[/mask] --dst [!] address[/mask] --sport [!] port1[:port2] --dport [!] port1[:port2] -j [REJECT|DROP|ACCEPT]
*/

$var_names[] = "input_ifc";
$var_names[] = "src_ip";
$var_names[] = "not_src_ip";
$var_names[] = "dst_ip";
$var_names[] = "not_dst_ip";
$var_names[] = "src_port";
$var_names[] = "not_src_port";
$var_names[] = "dst_port";
$var_names[] = "not_dst_port";
$var_names[] = "protocol";
$var_names[] = "enabled";
$var_names[] = "comment";
$var_names_count = count($var_names);

if (strlen($netmode) == 0) {
	$netmode = cfg_get_def($cfg, "netmode", "bridge");
}

$i = 0;
while ($i < 20)
{
	$i++;
	$j = 0;
	$firewall_cfg = cfg_get_firewall_cfg($cfg, $i, $var_names, $netmode);
	while ($j < $var_names_count)
	{
		$var = $var_names[$j] + $i;
		if (!isset($$var))
		{
			$$var = $firewall_cfg[$j];
		}
		/* echo "" + $i + ": " + $var + " -> " + $$var + "<br>\n"; */
		$j++;
	}
}

$saved = 0;
if ($REQUEST_METHOD == "POST" && $action == "firewallstore")
{
	$i = 0;
	while ($i < 20)
	{
		$i++;
		$j = 0;
		while ($j < $var_names_count)
		{
			$var = $var_names[$j] + $i;
			$values[$j] = $$var;
			$j++;
		}
		set_firewall_cfg($cfg, $i, $var_names, $values, $netmode);
	}
	cfg_save($cfg, $cfg_file);
	cfg_set_modified($cfg_file);
	$saved = 1;
}

/* $error_msg = "Belekox eroras..."; */
><!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
 "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title><? echo get_title($cfg, dict_translate("Firewall")); ></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="Pragma" content="no-cache">
<link href="FULL_VERSION_LINK/style.css" rel="stylesheet" type="text/css">
<link href="FULL_VERSION_LINK/traceroute.css" rel="stylesheet" type="text/css">
<script type="text/javascript" language="javascript" src="jsl10n.cgi"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/jsval.js"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/network.js"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/util.js"></script>
<script type="text/javascript" language="javascript">
//<!--
function updateEnabled(checkbox, hidden)
{
	if (checkbox.checked)
	{
		hidden.value = "enabled";
	}
	else
	{
		hidden.value = "disabled";
	}
}

function updateNot(checkbox, hidden)
{
	if (checkbox.checked)
	{
		hidden.value = "!";
	}
	else
	{
		hidden.value = "";
	}
}

function updatePorts(id, value)
{
	idx = id.replace(/^([^\d]+)(\d+)$/, "$2");
	setDisabled(document.getElementById("src_port" + idx), value < 2);
	setDisabled(document.getElementById("dst_port" + idx), value < 2);
	setDisabled(document.getElementById("not_src_port" + idx), value < 2);
	setDisabled(document.getElementById("not_dst_port" + idx), value < 2);
	setDisabled(document.getElementById("src_port_chk" + idx), value < 2);
	setDisabled(document.getElementById("dst_port_chk" + idx), value < 2);
	setDisabled(document.getElementById("not_src_port_chk" + idx), value < 2);
	setDisabled(document.getElementById("not_dst_port_chk" + idx), value < 2);
}

<? if ($saved) { >
window.opener.doSubmit();
window.close();
<? } >

var line_chain = new Array("src_ip", "dst_ip", "src_port", "dst_port");

function validateFirewallPort(id, name, value)
{
	/* trim */
	value = value.replace(/^\s+|\s+$/g, '');
	idx = id.replace(/^([^\d]+)(\d+)$/, "$2");
	if (value != '')
	{
		if ((pos = value.indexOf(':')) >= 0)
		{
			from = value.substr(0, pos);
			to = value.substr(pos+1);
			if (isNaN(from) || isNaN(to))
				return false;
			intfrom = parseInt(from);
			intto = parseInt(to);
			if (intfrom != from || intto != to || intfrom < 1 ||
				intfrom > 65535 || intto < 1 || intto > 65535 ||
				intfrom > intto)
				return false;
		}
		else if (isNaN(value) || parseInt(value) != value ||
					parseInt(value) < 1 || parseInt(value) > 65535)
		{
			return false;
		}
	}
	return true;
}

function validateFirewallIP(id, name, value)
{
	value = value.replace(/^\s+|\s+$/g, '');
	idx = id.replace(/^([^\d]+)(\d+)$/, "$2");

	if (value == '')
	{
		dep = document.getElementById("active" + idx);
		if (dep.checked)
		{
			dep = document.getElementById(name);
			dep.value = "0.0.0.0/0";
		}
		return true;
	} else {
		if ((pos = value.indexOf('/')) >= 0) {
			mask = value.substr(pos+1);
			if (isNaN(mask) || parseInt(mask) != mask || parseInt(mask) < 0 ||
				parseInt(mask) > 32) {
				return false;
			}
			value = value.substr(0, pos);
		}
		if (_validateIP(value)) {
			return true;
		}
	}
	return false;
}

//-->
</script>
</head>
<body class="popup">
	<form name="firewall" enctype="multipart/form-data" action="firewall.cgi"
	method="POST" onSubmit="return validateStandard(this, 'error');">
		<table cellspacing="0" cellpadding="0" align="center" class="popup">
			<tr><th colspan="3"><? echo dict_translate("Firewall"); ></th></tr>
    		<tr>
		<td colspan="3">
    <div id="error" <?if (isset($error_msg)) { echo "class=\"error\""; }>><?echo $error_msg></div>
    <br class="zero">
		  <table cellspacing="0" cellpadding="0">
		  <tr>
		  <td class="h">&nbsp;</td>
		  <td class="h"><? echo dict_translate("Interface"); ></td>
		  <td class="h"><? echo dict_translate("IP Type"); ></td>
		  <td class="h"><? echo dict_translate("Not"); ></td>
		  <td class="h"><? echo dict_translate("Source IP/mask"); ></td>
		  <td class="h"><? echo dict_translate("Not"); ></td>
		  <td class="h"><? echo dict_translate("Src Port"); ></td>
		  <td class="h"><? echo dict_translate("Not"); ></td>
		  <td class="h"><? echo dict_translate("Destination IP/mask"); ></td>
		  <td class="h"><? echo dict_translate("Not"); ></td>
		  <td class="h"><? echo dict_translate("Dst Port"); ></td>
		  <td class="h"><? echo dict_translate("Comment"); ></td>
		  <td class="h"><? echo dict_translate("On"); ></td>
		  </tr>
<?
$i = 0;
while ($i < 20)
{
	$i++;
	$j = 0;
	while ($j < $var_names_count)
	{
		$var = $var_names[$j] + $i;
		$var_name = $var_names[$j];
		$$var_name = $$var;
		$j++;
	}
>		  <tr>
		  <td class="h"><? echo $i;>.</td>

		  <td><select name="input_ifc<? echo $i;>" id="input_ifc<? echo $i;>">
		  	<option value="" <? if (strlen($input_ifc) == 0) { echo "selected"; }> ><? echo dict_translate("ANY"); ></option>
		  	<option value="ath0" <? if ($input_ifc == "ath0") { echo "selected"; }> ><? echo dict_translate("WLAN"); ></option>
		  	<option value="eth0" <? if ($input_ifc == "eth0") { echo "selected"; }> ><? echo dict_translate("LAN"); ></option>
                        <? if ($netmode == "router") { >
		  	<option value="ppp+" <? if ($input_ifc == "ppp+") { echo "selected"; }> ><? echo dict_translate("PPP"); ></option>
                        <? } >
		      </select>
		  </td>

		  <td><select name="protocol<? echo $i;>" id="protocol<? echo $i;>" onChange="updatePorts('protocol<? echo $i;>', this.value);">
		  	<option value="0" <? if ($protocol == "0") { echo "selected"; }> ><? echo dict_translate("IP"); ></option>
		  	<option value="1" <? if ($protocol == "1") { echo "selected"; }> ><? echo dict_translate("ICMP"); ></option>
		  	<option value="6" <? if ($protocol == "6") { echo "selected"; }> ><? echo dict_translate("TCP"); ></option>
		  	<option value="17" <? if ($protocol == "17") { echo "selected"; }> ><? echo dict_translate("UDP"); ></option>
                        <? if ($netmode == "router") { >
                        <option value="-1" <? if ($protocol == "-1") { echo "selected"; }> ><? echo dict_translate("P2P"); ></option>
                        <? } >
			</select>
		  </td>

                  <td><input type="hidden" name="not_src_ip<? echo $i;>" id="not_src_ip<? echo $i;>" value="<? echo $not_src_ip;>">
                  <input type="checkbox" name="not_src_ip_chk<? echo $i;>" id="not_src_ip_chk<? echo $i;>" value="!"
                  <?if ($not_src_ip == "!") {echo "checked";}> onClick="updateNot(this, this.form.not_src_ip<? echo $i;>);"></td>

		  <td><input type="text" name="src_ip<? echo $i;>" id="src_ip<? echo $i;>"
		  value="<? echo $src_ip;>" size="16" maxlength="18"
		  required="1" callback="validateFirewallIP" realname="<? echo dict_translate("Source IP/mask"); >"></td>

                  <td><input type="hidden" name="not_src_port<? echo $i;>" id="not_src_port<? echo $i;>" value="<? echo $not_src_port;>"
                  <?if (strlen($protocol) == 0 || intVal($protocol) < 2) { echo "disabled"; }> >
                  <input type="checkbox" name="not_src_port_chk<? echo $i;>" id="not_src_port_chk<? echo $i;>" value="!"
                  <?if (strlen($protocol) == 0 || intVal($protocol) < 2) { echo "disabled"; }
                    if ($not_src_port == "!") {echo "checked";}> onClick="updateNot(this, this.form.not_src_port<? echo $i;>);"></td>

		  <td><input type="text" name="src_port<? echo $i;>" id="src_port<? echo $i;>"
		  value="<? echo $src_port;>" size="6" maxlength="11"
		  required="1" callback="validateFirewallPort" realname="<? echo dict_translate("Src Port"); >"
                  <?if (strlen($protocol) == 0 || intVal($protocol) < 2) { echo "disabled style='backgroundColor: #d0d0d0;'"; }> ></td>

                  <td><input type="hidden" name="not_dst_ip<? echo $i;>" id="not_dst_ip<? echo $i;>" value="<? echo $not_dst_ip;>">
                  <input type="checkbox" name="not_dst_ip_chk<? echo $i;>" id="not_dst_ip_chk<? echo $i;>" value="!"
                  <?if ($not_dst_ip == "!") {echo "checked";}> onClick="updateNot(this, this.form.not_dst_ip<? echo $i;>);"></td>

		  <td><input type="text" name="dst_ip<? echo $i;>" id="dst_ip<? echo $i;>"
		  value="<? echo $dst_ip;>" size="16" maxlength="18"
		  required="1" callback="validateFirewallIP" realname="<? echo dict_translate("Destination IP/mask"); >"></td>

                  <td><input type="hidden" name="not_dst_port<? echo $i;>" id="not_dst_port<? echo $i;>" value="<? echo $not_dst_port;>"
                  <?if (strlen($protocol) == 0 || intVal($protocol) < 2) { echo "disabled"; }> >
                  <input type="checkbox" name="not_dst_port_chk<? echo $i;>" id="not_dst_port_chk<? echo $i;>" value="!"
                  <?if (strlen($protocol) == 0 || intVal($protocol) < 2) { echo "disabled"; }
                    if ($not_dst_port == "!") {echo "checked";}> onClick="updateNot(this, this.form.not_dst_port<? echo $i;>);"></td>

		  <td><input type="text" name="dst_port<? echo $i;>" id="dst_port<? echo $i;>"
		  value="<? echo $dst_port;>" size="6" maxlength="11"
		  required="1" callback="validateFirewallPort" realname="<? echo dict_translate("Dst Port"); >"
                  <?if (strlen($protocol) == 0 || intVal($protocol) < 2) { echo "disabled style='backgroundColor: #d0d0d0;'"; }> ></td>

 		  <td><input type="text" name="comment<? echo $i;>" id="comment<? echo $i;>" value="<? echo $comment;>" size="9"></td>

		  <td>
		  	<input type="hidden" name="enabled<? echo $i;>"
		  		id="enabled<? echo $i;>" value="<?echo $enabled>">
		  	<input type="checkbox" name="active<? echo $i;>"
		  	id="active<? echo $i;>" onClick="updateEnabled(this, this.form.enabled<? echo $i;>);"
		  	<? if ($enabled == "enabled") {echo "checked";}> >
                  </td>
		  </tr>
<?
}
>
		  <tr>
		    <td colspan="3"><input type="hidden" name="action" value="firewallstore"></td>
		    <td colspan="3"><input type="hidden" name="netmode" value="<? echo $netmode>"></td>
		    <td colspan="3">
		    <input type="submit" name="firewall_submit" value="<? echo dict_translate("Save")>">
		    <input type="button" name="cancel" value="<? echo dict_translate("Cancel")>"
		    onClick="window.close()">
		    </td>
		  </tr>
		  </table>
		</td>
		</table>
	</form>
</body>
</html>
