#!/sbin/cgi
<html>
<head>
<title>Testing Language Translation Upload</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<style type="text/css">
body, td, th, table {
    font-family: Verdana, Arial, Helvetica, sans-serif;
    font-size: 12px;
}
th { border: 1px solid #aaa;
background-color: #eee;
color: #900;
text-align: left;
text-indent: 10px;
white-space: nowrap;
margin-left: 10px;
font-size: 14px;
font-weight: normal;
letter-spacing: 0.3em;
width: 100%;
}
td { padding-left: 20px; padding-right: 20px; padding-top: 5px }
table { border: 0px; width: 700px }
pre {
background-color: #FFFCE2; 
border: 1px solid #666; 
padding: 5px 5px 5px 5px;
}
input[type=submit], input[type=reset] {
background: #eee;
color: #222;
border: 1px outset #ccc;
padding: .1em .5em;
}
input[type=text], input[type=file]{ padding: .25em .5em }
input[type=text]:focus, input[type=password]:focus, input[type=file]:focus { 
border: 1px solid #886 
}
input[type=text], input[type=file]{
background: #fff;
color: #000;
border: 1px solid #d7d7d7;
}
</style>
</head>
<?

Function trim $str
(
	return ereg_replace("\s+$", '', ereg_replace("(^\s+)", '', $str));
);

$modified = 0;
if ($REQUEST_METHOD=="POST" && isset($upload))
{
	$new_name = trim($new_name);
	if ($new_name == "")
	{
		$new_name = strrchr($file, "/");
		if (substr($new_name, 0, 1) == "/")
		{
			$new_name = substr($new_name, 1, strlen($new_name) - 1);
		}
	}
	chmod($file, "644");	
	@mkdir("/etc/persistent/lang/", 0755);
	exec("mv "+$file+" /etc/persistent/lang/"+$new_name);
	$modified = 1;
	$uploaded = 1;
}
elseif ($REQUEST_METHOD=="POST" && isset($rename) && strchr($new_name, "/") == "")
{
	$new_name = trim($new_name);
	if ($new_name != "" && $dictionary_file != "")
	{
		rename("/etc/persistent/lang/"+$dictionary_file, "/etc/persistent/lang/"+$new_name);
		$modified = 1;
	}
}
elseif ($REQUEST_METHOD=="POST" && isset($delete))
{
	if ($dictionary_file != "")
	{
		unlink("/etc/persistent/lang/"+$dictionary_file);
		$modified = 1;
	}	
}
if ($modified)
{
	exec("cfgmtd -w -p /etc/");
}

$lang_options = "";
@openDir("/etc/persistent/lang");
$dir = @readDir();
while ($dir)
{
	if (substr($dir,0,1) != ".")
	{
		$lang_options += "<option value=\""+$dir+"\">"+$dir+"</option>\n";  
		$lang_files[] = $dir;
	}
	$dir = readDir();
}
closeDir();
$n = count($lang_files);
?>
<body bgcolor=white>
<a href="index.cgi">Main</a>
<form enctype="multipart/form-data" action="<?echo $PHP_SELF;>" method="POST">
<table align="center">
<tr><th colspan="2">Upload File</th></tr>
<? if ($lang_options != "") {>
<tr><td>
Dictionaries:
<select name="dictionary_file">
<? echo $lang_options; >
</select>
</td>
<td>
<input type="submit" name="delete" value="Delete">
</td></tr>
<? } >
<tr><td>
New name:<input type="text" name="new_name" value="">
</td>
<td>
<? if ($lang_options != "") {>
<input type="submit" name="rename" value="Rename"><br>
<? } else {>
&nbsp;
<? } >
</td></tr>
<tr><td>
File: <input name="file" type="file"><br>
</td>
<td>
<input type="submit" name="upload" value="Upload"><br>
</td></tr>
<?
if ($uploaded)
{
    echo("<tr><td colspan=\"2\"><pre>\n");
    echo("Uploaded file: " + htmlspecialchars($file) + "\n");
    echo("Uploaded file size: " + $file_size);
    echo("\n</pre></td></tr>");
}
>
</table>
</form>
</body>
</html>
