<?
$wmm_names[0] = dict_translate("No QoS");
$wmm_names[1] = dict_translate("Auto Priority");
$wmm_names[2] = dict_translate("Video Priority");
$wmm_names[3] = dict_translate("Voice Priority");
$wmm_values[0] = -1;
$wmm_values[1] = 0;
$wmm_values[2] = 4;
$wmm_values[3] = 8;

Function wmm_get_status $wmm_level (
   if ($wmm_level == "-1") {
       $status = "disabled";
   }
   else
   {
	   $level = intval($wmm_level);
	   $status = "disabled";
	   switch ($level) {
	   case 0;
	   case 4;
	   case 8;
	       $status = "enabled";
	       break;
	   }
   }

   return $status;
);

Function wmm_get_levelname $wmm_status, $wmm_level (
   global $wmm_names;
   global $wmm_values;
   $levelname = $wmm_names[0];
   if ($wmm_status == "enabled" || $wmm_status == 1) {
       $i = 0;
       while ($i < count($wmm_values)) {
           if ($wmm_values[$i] == $wmm_level) {
               $levelname = $wmm_names[$i];
               $i = count($wmm_values) - 1;
           }
           $i++;
       }
   }

   return $levelname;
);

Function wmm_generate_options $wmm_status, $wmm_level (
   global $wmm_names;
   global $wmm_values;

   $selectedName = wmm_get_levelname($wmm_status, $wmm_level);
    
   $i = 0;
   while ($i < count($wmm_values)) {
        $options += "<option value=\"" + $wmm_values[$i] + "\"";
        $name = $wmm_names[$i];
        if ($name == $selectedName) {
            $options += " selected";
        }
        $options += ">" + $name + "</option>";
        $i++;
   }

   return $options;
);

Function cfg_set_signal_leds $cfg, $led1, $led2, $led3, $led4 (
	cfg_set($cfg, "wireless.1.signal_led1", $led1);
	cfg_set($cfg, "wireless.1.signal_led2", $led2);
	cfg_set($cfg, "wireless.1.signal_led3", $led3);
	cfg_set($cfg, "wireless.1.signal_led4", $led4);
);

Function cfg_get_leds $cfg (
	$v[0] = cfg_get_def($cfg, "wireless.1.signal_led1", "94");
	$v[1] = cfg_get_def($cfg, "wireless.1.signal_led2", "80");
	$v[2] = cfg_get_def($cfg, "wireless.1.signal_led3", "73");
	$v[3] = cfg_get_def($cfg, "wireless.1.signal_led4", "65");

	return $v;
);

Function secsToCountdown $time
(
	$time = IntVal($time);
	$days = $time / 86400;
	$hours = ($time / 3600) % 24;
	$minutes = ($time / 60) % 60;
	$secs = $time % 60;
		
	if ($days > 0)
	{
		$result = sprintf("%d %s %.2d:%.2d:%.2d",
			$days, dict_translate("day(-s)"), 
			$hours, $minutes, $secs);
	}
	else
	{
		$result = sprintf("%.2d:%.2d:%.2d", $hours, $minutes, $secs);
	}
	return $result;
);


>
