var IP_regex = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;
function _validateIP(input) {
        return IP_regex.exec(input) != null;
}

function _validateNetmask(input)
{
	if (!_validateIP(input))
	{
		return false;
	}
	var quad = input.split('.');
	if (quad.length != 4)
	{
		return false;
	}
	var mask_val = parseInt(quad[0])*16777216 + 65536 * parseInt(quad[1]) +
		256 * parseInt(quad[2]) + parseInt(quad[3]);
	mask_val = 256*256*256*256 - mask_val - 1;
	return (mask_val & (mask_val + 1)) == 0;  
}

function changeNetworkMode(s,mode){
	var idx = s.selectedIndex;
	var newval = s.options[idx].value;
	if (newval != mode) {window.location.href="network.cgi?netmode="+newval;}
}

function validateBridgeIP(id, name, value) {
	var dhcp = document.getElementById("dhcp");
	if (!dhcp.checked) { return _validateIP(value) && value != "0.0.0.0"; }
	return true;
}

function validateBridgeNetmask(id, name, value) {
	var dhcp = document.getElementById("dhcp");
	if (!dhcp.checked) { return _validateNetmask(value) && value != "0.0.0.0"; }
	return true;
}

function validateBridgeOptIP(id, name, value) {
	var dhcp = document.getElementById("dhcp");
	if (!dhcp.checked && value.length > 0) { return _validateIP(value);  }
	return true;
}
var IPMODE_STATIC = 0;
var IPMODE_DHCP = 1;
var IPMODE_PPPOE = 2;
function chooseRouterIP(mode, is_ap){
	var apst = ['lanip','lanmask'];
	var stast = ['wlanip', 'wlanmask'];
	var st = new Array('wangw','dns1','dns2');
	var pppoe = new Array('wanppoeuser','wanppoepass', 'wanpppoemppe', 'pppoemtu', 'pppoemru');
	var dhcp = new Array('fallback_ip');
	var e = new Array();
	var d = new Array();
	if (is_ap)
	{
		st = st.concat(apst);
	}
	else
	{
		st = st.concat(stast);
	}
	switch (mode) {
	case IPMODE_STATIC:
		e=e.concat(st);
		d=d.concat(pppoe, dhcp);
		break;
	case IPMODE_DHCP:
		e=e.concat(dhcp);
		d=d.concat(st, pppoe);
		break;
	case IPMODE_PPPOE:
		e=e.concat(pppoe);
		d=d.concat(st, dhcp);
		break;
	}
	for (i=0;i<e.length;++i){
		var o=document.getElementById(e[i]);
		if (o) {o.disabled=false}
	}
	for (i=0;i<d.length;++i){
		var o=document.getElementById(d[i]);
		if (o) {o.disabled=true}
	}
}
function chooseBridgeIP(mode) {
	var st = new Array('brip', 'brnetmask','brgw','dns1','dns2');
	var dhcp = new Array('fallback_ip');
	var e = new Array();
	var d = new Array();
	switch (mode) {
	case IPMODE_STATIC:
		e=e.concat(st);
		d=d.concat(dhcp);
		break;
	case IPMODE_DHCP:
		e=e.concat(dhcp);
		d=d.concat(st);
		break;
	}
	for (i=0;i<e.length;++i){
		var o=document.getElementById(e[i]);
		if (o) {o.disabled=false}
	}
	for (i=0;i<d.length;++i){
		var o=document.getElementById(d[i]);
		if (o) {o.disabled=true}
	}

}
function validateWanIP(id, name, value) {
var val = getRadioValue("wlanipmode");
if (parseInt(val) == IPMODE_STATIC) { return _validateIP(value) && value != "0.0.0.0"; }
return true;
}
function validateWanNetmask(id, name, value) {
var val = getRadioValue("wlanipmode");
if (parseInt(val) == IPMODE_STATIC) { return _validateNetmask(value) && value != "0.0.0.0"; }
return true;
}
function validateWlanOptIP(id, name, value) {
var val = getRadioValue("wlanipmode");
if (parseInt(val) == IPMODE_STATIC && value.length > 0) { return _validateIP(value); }
return true;
}
function validateWlanPPPoE(id, name, value) {
var val = getRadioValue("wlanipmode");
if (parseInt(val) == IPMODE_PPPOE) { return value != null && value.length > 0; }
return true;
}
function validateLanIP(id,name,value) {
return _validateIP(value) && value != "0.0.0.0";
}
function validateLanNetmask(id,name,value) {
return _validateNetmask(value) && value != "0.0.0.0";
}
function validateDMZIP(id,name,value) {
var dmz = document.getElementById("dmz_status");
if (dmz.checked) { return _validateIP(value) && value != "0.0.0.0"; }
return true;
}
function dhcpdStatusClicked() {
var c=document.getElementById('dhcpd_status');
statusClicked(c,new Array('dhcpd_start','dhcpd_end','dhcpd_netmask','dhcpd_lease', 'dhcpd_dnsproxy_status'));
}
function validateDhcpdIP(id,name,value) {
var c=document.getElementById('dhcpd_status');
if (c.checked) { return _validateIP(value) && value != "0.0.0.0"; }
return true;
}
function validateDhcpdNetmask(id,name,value) {
var c=document.getElementById('dhcpd_status');
if (c.checked) { return _validateNetmask(value) && value != "0.0.0.0"; }
return true;
}
function validateFallbackIP(id,name,value) {
var dhcp = document.getElementById("dhcp");
if (dhcp.checked) { return _validateIP(value) && value != "0.0.0.0"; }
return true;
}
