#!/sbin/cgi
<?
	include("lib/settings.inc");
	$cfg = @cfg_load($cfg_file);
	include("lib/l10n.inc");
	include("lib/link.inc");

>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title><? echo get_title($cfg, dict_translate("Channel Scan List")); ></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="Pragma" content="no-cache">
<link href="FULL_VERSION_LINK/style.css" rel="stylesheet" type="text/css">
<script type="text/javascript" language="javascript1.2" src="FULL_VERSION_LINK/slink.js"></script>
<script type="text/javascript" language="javascript">
//<!--
<? if ($feature_chanshift == 1) { ?>
var feature_chanshift = 1; 
<? } else { >
var feature_chanshift = 0; 
<? } 

generate_js_regdomain($country, "full_regdomain", $feature_ieee_mode_a,
	$feature_ieee_mode_bg, $feature_chanshift);
>

function index_of(array, value)
{
	/* Array has no indexOf on IE6 */
	if (array.indexOf)
	{
		return array.indexOf(value);
	}
	for (var i=0; i<array.length; i++)
	{
		if (this[i]==value)
		{
			return i;
		}
	}
	return -1;

}

function get_channels(regdomain, ieee_mode, clksel, chanshift)
{
	var i;
	var mode;
	var no_shift = !parseInt(chanshift);
	var channels;
	var result = new Array();
	
	mode = getRegdomainMode(ieee_mode);
	
	if (!regdomain[mode] || !regdomain[mode][clksel])
	{
		return result;
	}
	channels = regdomain[mode][clksel];

	for (i in channels)
	{
		if (no_shift && channels[i][2])
		{
			continue;
		}
		result[i] = channels[i][0];
	}
	return result;
}

function chooseScanChannels()
{
	var x;
	var i;	
	var selected_channels = new Array();
	for (i = 0; i < channels.length; ++i)
	{
	 	x = document.getElementById("channel_"+i);
		if (x && x.checked)
		{
			selected_channels.push(x.value);
		}
	}
	window.opener.setScanChannels(selected_channels.join(", "));
	window.close();
	return false;
}

function addRow(table, columns)
{
	var i;
	var tbody = table.getElementsByTagName("TBODY")[0];
	var row = document.createElement("TR");
	var td;

	for (i = 0; i < columns.length; ++i) {
		td = document.createElement("TD");
		td.innerHTML = columns[i];
		row.appendChild(td);    	
	}
	tbody.appendChild(row);
}

function fill_table(channels, table_id, selected_channels)
{
	var i;
	var columns = new Array();
	var c = 0;
	var table = document.getElementById(table_id);
	
	if (!table)
	{
		return false;
	}
	
	for (i in channels)
	{
		columns.push("<input type=\"checkbox\" id=\"channel_" + c
			+ "\" name=\"channel_" + c + "\" value=\"" + i + "\""
			+ (index_of(selected_channels,i) == -1 ? "" : " checked") + ">"
			+ i + " - " + channels[i] + " MHz");
		c++;
		if ((c % 5) == 0)
		{
			addRow(table, columns);
			columns = new Array();
		}
	}
	if (columns.length == 0)
	{
		return true;
	}
	for (i = columns.length; i < 5; i++)
	{
		columns.push("&nbsp;");
	}
	addRow(table, columns);
	return true;
}

var ieee_mode = "<?echo $ieee_mode>".toLowerCase();
var clksel = "<?echo $clksel>";
var chanshift="<?echo $chanshift>";
var regdomain = parse_full_regdomain(full_regdomain, chanshift);
var channels = get_channels(regdomain, ieee_mode, clksel, chanshift);


function init()
{
	var selected_channels = "<? echo ereg_replace("[\" ]","", $scan_channels);>".split(",");	
	fill_table(channels, "channels", selected_channels);
}

window.onload=init
//-->
</script>
</head>

<body class="popup">
<br>
<form enctype="multipart/form-data" action="#" method="POST" onSubmit="return chooseScanChannels();">
<table cellspacing="0" cellpadding="0" align="center" id="channels">
<tbody></tbody>
</table>
<br />
<table cellspacing="0" cellpadding="0" align="center" id="channels">
<tr>
<td><input type="submit" value="<? echo dict_translate("Select");>"></td>
<td><input style="margin-left: 5em" type="button" value="Close this window" onClick="window.close()"></td>
</tr>
</table>
</form>
</body>
</html>


