function ack2meters(ack, min)
{
	/*
	Units of ack are uSeconds and ack is approximately 2x distance 
	(plus some negligible offset accounted for by the minimum ack timeout which covers 0-300 meters or so) 
	So the speed of light is ~300 meters/microsecond and ack timeout is roundtrip so 
	we can take time_uS * 300 / 2 or time_uS * 150; 
	extra_ack_uS * 150;
	*/
	if (ack < min)
	{
		return 0;
	}
	return (ack - min) * 150;
}

function AckController(ack, dst, slider)
{
	this.ack = ack;
	this.dst = dst;
	this.slider = slider;
	this.maximum = 0; 

	ack.controller = this;
	dst.controller = this;
	slider.controller = this;

	this.setMaximum = function(decimiles)
	{
		this.maximum = decimiles;
	} 
		
	this.updated = function(obj, decimiles)
	{
		if (decimiles < 0)
		{
			decimiles = 0;
		}
		else if(decimiles > this.maximum)
		{
			decimiles = this.maximum;
		}
		this.slider._isChanging = true;
		this.slider.setValue(Math.round(decimiles));
		this.slider._isChanging = false;

		this.dst.setValue(Math.round(decimiles));
	
		this.ack.setValue(decimiles);
	}
}

function createSlider(minacktimeout, maxacktimeout)
{
	var kilometers_per_mile = 1.609344;
	var slider = new Slider(document.getElementById("slider-1"),
		document.getElementById("slider-input-1"));
	var ack = document.getElementById("acktimeout");
	var dst = document.getElementById("distance");

	var controller = new AckController(ack, dst, slider);

	/* Will operate with decimile(0.1mile) steps:
	 
	   kilometers = meters / 1000
	   miles      = kilometers / kilometers_per_mile
	   decimiles = miles * 10
	 */
	controller.setMaximum(ack2meters(maxacktimeout, minacktimeout)
		/100/kilometers_per_mile);	
	slider.setMaximum(Math.round(ack2meters(maxacktimeout, minacktimeout)
		/100/kilometers_per_mile));

	slider.onchange = function()
	{
		if (!this._isChanging)
		{
			this.controller.updated(this, this.getValue());
		}
	};
		
	dst.slider = slider;
	dst.onchange = function()
	{
		var miles = parseFloat(this.value);
		var decimiles;
		if (isNaN(miles))
		{
			miles = 0;
		}
		decimiles = Math.floor(miles * 10);
		this.controller.updated(this, decimiles);
	};
	dst.distkm = document.getElementById("distkm");
	
	dst.setValue = function(decimiles)
	{
		this.value = decimiles / 10;
		if (this.distkm)
		{
			this.distkm.innerHTML = Math.round(decimiles * kilometers_per_mile) / 10;
		}
	};


	ack.slider = slider;
	ack.distance = document.getElementById("ackdistance");
	ack.setValue = function(decimiles)
	{
		var dist_m = Math.round(decimiles * 100 * kilometers_per_mile);
		this.value = Math.round(dist_m/150) + minacktimeout;
		if (this.distance)
		{
			this.distance.value = Math.round(dist_m/150) * 150;
		}
	}
	
	ack.onchange = function()
	{
		var acktime = parseInt(this.value);
		var decimiles;
		if (isNaN(acktime))
		{
			acktime = minacktimeout; // Minimum value...
		}
		decimiles = ack2meters(acktime, minacktimeout)/100/kilometers_per_mile;
		this.controller.updated(this, decimiles);
	};
	
	ack.onchange();
}

function createTxPowerSlider(maxPower) {
	var slider = new Slider(document.getElementById("slider-2"),
		   document.getElementById("slider-input-2"));
	var power = document.getElementById("txpower");
	slider.setMaximum(maxPower);

	slider.onchange = function () {
		document.getElementById("txpower").value = this.getValue();
	};

	power.slider = slider;
	power.onchange = function () {
		var intVal = parseInt(this.value);
		if (intVal == NaN) intVal = 0;
		this.slider.setValue(intVal);
	};
	power.onchange();
}

function setESSID(info) {
 var parts = info.split('#');
 var mac="";
 var ssid="";
 var sec="none";
 if (parts.length >= 3) {
  mac = parts[0];
  sec = parts[1];
  parts.reverse();
  parts.pop();parts.pop();
  parts.reverse();
  ssid = parts.join('#');
  sec = sec.toLowerCase();
  if (sec == '-') { sec = 'none'; }
 }
 var essid = document.getElementById('essid');
 var apmac = document.getElementById('apmac');
 if (essid) { essid.value = ssid; apmac.value = ''; }
 if (apmac && ssid.length == 0) { apmac.value = mac; essid.value = 'any'; }
 var security = document.getElementById('security');
 if (security) { selectOption(security, sec); security.onchange(); }
}

function ieee_mode_fixer(ieee_mode, clksel)
{
	this.ieee_mode = ieee_mode;
    if (clksel == "") clksel = "0";
	this.clksel = clksel;

	// TODO: consider about: "gt"
	this.isATurbo = function()
	{
		return this.ieee_mode == "at" || this.ieee_mode == "ast";
	}
	
	this.getIEEEMode = function()
	{
		return this.isATurbo() ? "a" : this.ieee_mode;
	}
	
	this.getClkSel = function()
	{	
		return this.isATurbo() ? "T" : this.clksel;
	}
}

var rates_cck = new Array(1, 2, 5.5, 11);
var rates_ofdm = new Array(6, 9, 12, 18, 24, 36, 48, 54);

function hasCCK(ieee_mode, clksel)
{
	return ((clksel == 0) && (ieee_mode == "b" || ieee_mode == "g"));
}

function hasOFDM(ieee_mode, clksel)
{
	return (ieee_mode == "a" || ieee_mode == "g" || ieee_mode == "pureg");
}

function compareNum(a, b)
{
	return a - b;
}

function init_rates(regdomain, ieee_mode, clksel, value, rate_id, rate_auto_id)
{
	var rates = new Array();
	var rate = 0; 
	var divider = 1;
	var multiplier = 1;
	var options;
	var select;
	var auto = false;
	var found = false;

	select = document.getElementById(rate_id);
	if (!select)
	{
		return value;
	}
	if (rate_auto_id)
	{
		auto = document.getElementById(rate_auto_id);
	}
	if (!auto || !auto.checked)
	{
		// Take lowest rate if not found
		auto = false;
	}
	else
	{
		// Take highest rate if not found
		auto = true;
	}
	
	/* make this work without regdomain */
	if (!regdomain || regdomain[getRegdomainMode(ieee_mode)])
	{
		if (clksel == 1)
		{
			divider = 2;
		}
		else if (clksel == 2)
		{
			divider = 4;
		}
		else if (clksel == 'T')
		{
			multiplier = 2;
		}
		if (hasCCK(ieee_mode, clksel))
		{
			rates = rates.concat(rates_cck);
		}
		if (hasOFDM(ieee_mode, clksel))
		{
			rates = rates.concat(rates_ofdm);
		}
		rates.sort(compareNum);
	}

	options = select.options;
	if (options.length)
	{
		value = select.options[select.selectedIndex].value;
	}
	options.length = 0;
	for (i in rates)
	{
		rate = ""+rates[i];
		if (multiplier > 1)
		{
			rate *= multiplier;
		}
		else if (divider > 1)
		{
			rate /= divider;
		}
		rate_value = ""+(rates[i]/divider)+"M";
		options[options.length] =
			new Option(rate, rate_value, false, value == rate_value);
		if (value == rate_value)
		{
			found = true;
		}
	}
	if (!found && auto && options.length)
	{
		select.options[options.length - 1].selected = true;
	}
	return options.length ? select.options[select.selectedIndex].value : value;
}

function setWepEnabled(enabled, do_focus) {
	var keylen = document.getElementById("wep_key_len");
	var keyid = document.getElementById("wep_key_id");
	var key = document.getElementById("wep_key");
	var keytype = document.getElementById("wep_key_type");
	keylen.disabled = !enabled;
	keyid.disabled = !enabled;
	key.disabled = !enabled;
	if (keytype) { keytype.disabled = !enabled; }
	if (do_focus && enabled) {
		key.focus();
	}
	
}

function setWpaEnabled(enabled, do_focus) {
	var key = document.getElementById("wpa_key");
        var obj = document.getElementById("wpa_auth");
	setDisabled(key, !enabled);
	setDisabled(obj, !enabled);
        if (obj) {
		var psk = obj.value.toUpperCase();
	        if (psk == "WPA-PSK") {
			setDisabled(document.getElementById("wpa_eap"), true);
			setDisabled(document.getElementById("wpa_inner"), true);
			setDisabled(document.getElementById("wpa_ident"), true);
			setDisabled(document.getElementById("wpa_user"), true);
			setDisabled(document.getElementById("wpa_passwd"), true);
	        } else {
			setDisabled(document.getElementById("wpa_key"), true);
			setDisabled(document.getElementById("wpa_eap"), !enabled);
			setDisabled(document.getElementById("wpa_inner"), !enabled);
			setDisabled(document.getElementById("wpa_ident"), !enabled);
			setDisabled(document.getElementById("wpa_user"), !enabled);
			setDisabled(document.getElementById("wpa_passwd"), !enabled);
	        }        	
		if (do_focus && enabled) {
			obj.focus();
		}
        } else {
		if (do_focus && enabled) {
			key.focus();
		}
        }
}

function setAuthTypeEnabled(enabled) {
	var a = document.getElementsByName("authtype");
	if (a == null)
		return;
	var i = 0;
	for (; i < a.length; ++i) {
		setDisabled(a[i], !enabled);
	}
}

function setMACClone(enabled) {
	var a = document.getElementById("macclone");
	if (a == null)
		return;
        setDisabled(a, !enabled);
        if (a.disabled) {
        	a.checked = false;
        }
}

function setAutoWDS(enabled) {
	var a = document.getElementById("wds_auto");
	if (a == null)
		return;
        setDisabled(a, !enabled);
        if (a.disabled) {
        	a.checked = false;
        }
}

function setWDSPeers(enabled) {
	var i = 1;
	for (; i <= 6; ++i) {
		var a = document.getElementById("peer"+i);
		if (a == null)
			continue;
                setDisabled(a, !enabled);
        	if (!enabled) a.value = "";
        }
}

function chooseSecurity(select, do_focus) {
	var mode = select.value.toUpperCase();
	var wmode = document.getElementById("wmode");
	var wpa = false;
	var wep = false;
	var authtype = false;
	var macclone = true;
	var wds = true;
	if (wmode != null)
		wmode = wmode.value.toLowerCase();
	if (mode == "WEP") {
		wpa = false;
		wep = true;
		authtype = true;
		updateWepError();
	} else if (mode.substring(0, 3) == "WPA") {
		wpa = true;
		wep = false;
		authtype = false;
		macclone = false;
		if (wmode == "apwds") {
			wds = false;
		}
	}
	setWpaEnabled(wpa, do_focus);
	setWepEnabled(wep, do_focus);
	setAuthTypeEnabled(authtype);
	setMACClone(macclone);
	setAutoWDS(wds);
	setWDSPeers(wds);
}

function chooseWPA(select, do_focus) {
        var sec = document.getElementById("security");
	var wpa = false;
	sec = sec.value.toUpperCase();
	if (sec.substring(0, 3) == "WPA") {
		wpa = true;
	} 
	setWpaEnabled(wpa, do_focus);
}

function chooseDiversity(diversity, name1, name2) {
	var o1 = document.getElementById(name1);
	var o2 = document.getElementById(name2);
	var disable = false;
	if (diversity.checked) {
		disable = true;
	}

	o1.disabled = disable;
	o2.disabled = disable;
}

var HwAddr_regex = /^([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F])$/

function validateHwAddr(id, name, value) {
	if (value != null && value.length > 0 && HwAddr_regex.exec(value) == null)
		return false;

	return true;
}

var WEP64_regex = /^([0-9]|[a-f]|[A-F]){10}$/
var WEP128_regex = /^([0-9]|[a-f]|[A-F]){26}$/
var WEP152_regex = /^([0-9]|[a-f]|[A-F]){32}$/

function updateWepError() {
	var key = document.getElementById("wep_key");
	var keylen = document.getElementById("wep_key_len");
	var keytype = document.getElementById("wep_key_type");

	if (keytype && keytype.value == "2")
	{
		if (keylen.value == "wep152")
		{
			key.realname = jsTranslate('msg_wep_key_format_16_ascii');
		}
		else if (keylen.value == "wep128")
		{
			key.realname = jsTranslate('msg_wep_key_format_13_ascii');
		}
		else
		{
			key.realname = jsTranslate('msg_wep_key_format_5_ascii');
		} 
	}
	else
	{
		if (keylen.value == "wep152")
		{
			key.realname = jsTranslate('msg_wep_key_format_16_hex');
		}
		else if (keylen.value == "wep128")
		{
			key.realname = jsTranslate('msg_wep_key_format_13_hex');
		}
		else
		{
			key.realname = jsTranslate('msg_wep_key_format_5_hex');
		} 
	}
}

function validateWepKey(id, name, value) {
	var security = document.getElementById("security");
	if (security.value.toUpperCase() == "WEP") {
		var key = document.getElementById(id);
		var keylen = document.getElementById("wep_key_len");
		var keytype = document.getElementById("wep_key_type");
		var len = 10;
		var regex = WEP64_regex;
		if (keylen.value == "wep128") {
			len = 26;
			regex = WEP128_regex;
		} 
		else if (keylen.value == "wep152") {
			len = 32;
			regex = WEP152_regex;
		} 
		if (keytype && keytype.value == "2") {
			regex = null;
			if (len == 10) {
				len = 5;
			} else if (len == 26) {
				len = 13;
			} else {
				len = 16;
			}
		}

		if (value == "" || value.length != len) {
			return false;
		}

		if (regex != null && regex.exec(value) == null) {
			return false;
		}
	}
	return true;
}

function validateWpaKey(id, name, value) {
	var security = document.getElementById("security");
	var upsec = security.value.toUpperCase();
	var auth = document.getElementById("wpa_auth");
	if (auth)
        	auth = auth.value.toUpperCase();
	if (upsec.substring(0, 3) == "WPA" && (auth != "WPA-EAP")) {
		if (value == "" || value.length < 8 || value.length > 63) {
			return false;
		}
		if (!/^[ -~]{8,63}$/.test(value))
		{
			return false;
		}
	}
	return true;
}

function validateWpaIdent(id, name, value) {
	var security = document.getElementById("security");
	security = security.value.toUpperCase();

	var auth = document.getElementById("wpa_auth");
	if (auth)
		auth = auth.value.toUpperCase();
        
	if (security.substring(0, 3) == "WPA" &&
            auth == "WPA-EAP") {
		if (value == "" || value.length < 1 || value.length > 63) {
			return false;
		}
		if (!/^[ -~]{1,63}$/.test(value))
		{
			return false;
		}
	}
	return true;
}

function shaperStatusClicked(){
	var o=document.getElementById('shaper_status');
	statusClicked(o,new Array('in_rate', 'out_rate', 'in_burst', 'out_burst'));
}

function getRegdomainMode(ieee_mode)
{
	if (ieee_mode == "a")
	{
		return "A";
	}
	if (ieee_mode == "b")
	{
		return "B";	
	}
	return "G"; 
}

function parse_full_regdomain(full_regdomain, chanshift)
{
	var i;
	var result;
	var mode;
	var freq;
	var clksel;
	var channel;
	var regdomain = new Array();
	var shifted = 0;
	
	// -1: workaround for explorer array termination (,) problem
	for (i = 1; i < full_regdomain.length - 1; i++)
	{
		result = full_regdomain[i].split(/\s+/);
		mode = result[2];
		freq = parseInt(result[0]);
		channel = result[1];
		
		if (mode == "T")
		{
			if (freq < 3000)
			{
				mode = "G";
				/* TODO: Skip 2GHz turbo for now */
				continue;
			}
			else
			{
				mode = "A";
			}
		}
		clksel = result[3];
		if (clksel == "20")
		{
			clksel = "0";
		}
		else if (clksel == "10")
		{
			clksel = "1";
		}
		else if (clksel == "5")
		{
			clksel = "2";
		}
		else
		{
			clksel = "T";
		}
		if (!regdomain[mode])
		{
			regdomain[mode] = new Array();
		}
		if (!regdomain[mode][clksel])
		{
			regdomain[mode][clksel] = new Array();
		}
		
		if (result.length < 6 || isNaN(result[5]))
			result[5] = 0;
		regdomain[mode][clksel][channel] = 
			new Array(result[0], parseFloat(result[4]), shifted, parseInt(result[5]));
		shifted = (!chanshift || shifted) ? 0 : 1; 
	}
	return regdomain;
}

function isCountryETSI(ccode) {
	var etsiList = [
		51,	/* Armenia */
		40,	/* Austria */
		31,	/* Azerbaijan */
		56,	/* Belgium */
		70,	/* Bosnia Herzegowina */
		100,	/* Bulgaria */
		191,	/* Croatia */
		196,	/* Cyprus */
		203,	/* Czech Republic */
		208,	/* Denmark */
		818,	/* Egypt */
		233,	/* Estonia */
		246,	/* Finland */
		250,	/* France */
		268,	/* Georgia */
		276,	/* Germany */
		300,	/* Greece */
		348,	/* Hungary */
		352,	/* Iceland */
		372,	/* Ireland */
		380,	/* Italy */
		428,	/* Latvia */
		438,	/* Liechtenstein */
		440,	/* Lithuania */
		442,	/* Luxembourg */
		470,	/* Malta */
		492,	/* Monaco */
		528,	/* Netherlands */
		530,	/* Netherlands-Antilles */
		578,	/* Norway */
		616,	/* Poland */
		620,	/* Portugal */
		642,	/* Romania */
		703,	/* Slovakia */
		705,	/* Slovenia */
		724,	/* Spain */
		752,	/* Sweden */
		756,	/* Switzerland */
		780,	/* Trinidad */
		788,	/* Tunisia */
		792,	/* Turkey */
		826	/* United Kingdom */
	];
        return (jQuery.inArray(parseInt(ccode), etsiList) != -1);
}
