#!/sbin/cgi
<?
include("lib/settings.inc");
$cfg = @cfg_load($cfg_file);
include("lib/l10n.inc");
>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" 
    "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title><? echo get_title($cfg, dict_translate("SpeedTest")); ></title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta http-equiv="Pragma" content="no-cache">
<link href="FULL_VERSION_LINK/style.css" rel="stylesheet" type="text/css">
<link href="FULL_VERSION_LINK/speedtest.css" rel="stylesheet" type="text/css">
<script type="text/javascript" language="javascript" src="jsl10n.cgi"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/ajax.js"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/util.js"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/tools.js"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/jsval.js"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/system.js"></script>
<script type="text/javascript" language="javascript" src="FULL_VERSION_LINK/speedtest.js"></script>
<script type="text/javascript" language="javascript">
//<!--
var iplist;
function validateManualIP(id,name,value) {
	var o = document.getElementById('dst_addr_select');
	if (!o) return false;
	if (o.selectedIndex == 0) {
		return validateIP(value) && value != "0.0.0.0";
	}
	return true;
}

function isAdvancedEnabled()
{
	o = document.getElementById("show_adv");
	return (o && o.checked);
}

function validateDuration(id,name,value)
{
	var val = parseInt(value);
	var o = document.getElementById('byte_limit');
	if (!isAdvancedEnabled())
	{
		return true;
	}
	if (value.length == 0)
	{
		return (o.value.length != 0);
	}
	if (isNaN(val) || val < 1 || val > 600)
	{
		return false;
	}
	o = document.getElementById('time_limit');
	o.value = val;
	return true;
}

function validateDataAmount(id,name,value)
{
	var val = parseInt(value);

	if (!isAdvancedEnabled())
	{
		return true;
	}
	if (value.length == 0)
	{
		return true;
	}
	if (isNaN(val) || val < 1 || val > 50000000)
	{
		return false;
	}
	var o = document.getElementById('byte_limit');
	o.value = val;
	return true;
}

function setupValidation() {
	var o = document.getElementById('dst_addr_input');
	if (o) { o.required=1; o.callback='validateManualIP'; o.realname='<? echo dict_translate("Destination IP"); >'; }
	o = document.getElementById('launcher_port');
	if (o) { o.required=1; o.minvalue=1; o.maxvalue=65535;o.realname='<? echo dict_translate("Remote WEB port"); >'; }
	o = document.getElementById('time_limit');
	if (o) { o.required=1; o.callback='validateDuration';o.realname='<? echo dict_translate("Duration"); >'; }
	o = document.getElementById('byte_limit');
	if (o) { o.required=1; o.callback='validateDataAmount';o.realname='<? echo dict_translate("Data amount"); >'; }
}
function runTest(f) {
	if (validateStandard(f, 'error')) {
		performTest(f);
	}
}
function init() {
	setupValidation();
	iplist = new IPList('dst_addr_select','dst_addr_input','ip_refresh');
	advanced = true; toggleAdvanced();
	o = document.getElementById("show_adv");
	if (o) o.checked = false;
	add_select_enter_submit('dst_addr_select', function() {runTest(document.speedtest);});
	testEnd(document.speedtest);
}
//-->
</script>
</head>
<body onLoad="init();" class="popup">
	<form name="speedtest" enctype="multipart/form-data" action="speedtest_action.cgi" method="POST" onSubmit="runTest(this);return false;">
	<table cellspacing="0" cellpadding="0" align="center" class="popup">
	<tr><th colspan="3"><? echo dict_translate("Network Speed Test"); ></th></tr>
	<tr>
	<td colspan="3">
	<div id="st_content">
	<table cellspacing="0" cellpadding="0">
	<tr><td>
	<div id="st_options">
	<table cellspacing="0" cellpadding="0" class="st_opt">
	<tr>
	  <td class="h"><? echo dict_translate("Select destination IP:"); ></td>
	  <td><select id="dst_addr_select" name="dst_addr_select"><option value="0"><? echo dict_translate("input manually"); ></option></select><img id="ip_refresh" src="FULL_VERSION_LINK/images/refresh.gif" width="16" height="16"></td>
	</tr>
	<tr>
	  <td class="h"><? echo dict_translate("or specify manually:"); ></td>
	  <td><input type="text" id="dst_addr_input" name="dst_addr_input" size="18"></td>
	</tr>
	<tr>
	  <td class="h"><? echo dict_translate("User:"); ></td>
	  <td><input type="text" name="auth_user" size="18"></td>
	</tr>
	<tr>
	  <td class="h"><? echo dict_translate("Password:"); ></td>
	  <td><input type="password" name="auth_password" size="18"></td>
	</tr>
	<tr>
	  <td class="h"><? echo dict_translate("Remote WEB port:"); ></td>
	  <td><input type="text" id="launcher_port" name="launcher_port" size="5" maxlength="5" value="80"></td>
	</tr>
	<tr>
	  <td class="h" colspan="2"><input type="checkbox" id="show_adv" name="show_adv" onClick="toggleAdvanced();"><? echo dict_translate("Show advanced options"); ></td>
	</tr>
	<tr id="advanced1" style="display: none;">
	  <td class="h"><? echo dict_translate("Direction:"); ></td>
	  <td><select id="direction_select" name="direction"><option value="both"><? echo dict_translate("both"); ></option><option value="receive"><? echo dict_translate("receive"); ></option><option value="transmit"><? echo dict_translate("transmit"); ></option><option value="duplex"><? echo dict_translate("duplex"); ></option></select></td>
	</tr>
	<tr id="advanced2" style="display: none;">
	  <td class="h"><? echo dict_translate("Duration:"); ></td>
	  <td><input type="text" id="time_limit" name="time_limit" value="10" size="10" /> &nbsp;<? echo dict_translate("seconds");></td>
	</tr>
	<tr id="advanced3" style="display: none;">
	   <td class="h"><? echo dict_translate("Data amount:"); ></td>
	   <td><input type="text" id="byte_limit" name="byte_limit" value="" size="10" /> &nbsp;<? echo dict_translate("bytes");></td>
	</tr>
	</table>
	</div>
	</td><td>
	<div id="st_results">
	  <span class="h"><? echo dict_translate("Test Results"); ></span>
	  <br /><span class="label"><? echo dict_translate("Rx:"); > <span id="rx_results"><? echo dict_translate("N/A"); ></span></span>
	  <br /><span class="label"><? echo dict_translate("Tx:"); > <span id="tx_results"><? echo dict_translate("N/A"); ></span></span>
	  <br /><div class="note" id="auth_warn" style="display: none;"><p><? echo dict_translate("warn_auth_problem|<strong>Warning:</strong> authentication problems!"); ></p></div>
	  <br /><div class="note" id="conn_warn" style="display: none;"><p><? echo dict_translate("warn_conn_problem|<strong>Warning:</strong> connection problems!"); ></p></div>
	  <br /><div class="note" id="icmp_warn" style="display: none;"><p><? echo dict_translate("warn_icmp_estimate|<strong>Warning:</strong> this is only rough estimation using ICMP!"); ></p></div>
	  <br />
	  <br />
	</div>
	</td></tr>
	</table>
	</div>
	</td>
	</tr>
	<tr><th colspan="3" class="sep">&nbsp;</th></tr>
	<tr><td colspan="3" id="run"><input id="runtest" type="submit" value="<? echo dict_translate("Run Test"); >"></td></tr>
        </table>
	</form>
</body>
</html>
