var advanced = false;
var test_in_progress = false;
var url = "";
var icmp_mode = false;

function setEstimateWarning(enable) {
	var o = document.getElementById("icmp_warn");
	if (!o) return;
	o.style.display = enable ? '' : 'none';
}

function setAuthenticationWarning(enable)
{
	var o = document.getElementById("auth_warn");
	if (!o) return;
	o.style.display = enable ? '' : 'none';
}

function setConnectionWarning(enable)
{
	var o = document.getElementById("conn_warn");
	if (!o) return;
	o.style.display = enable ? '' : 'none';
}

function setEstimateResults(results) {
	setReceiveResults(results);
	setTransmitResults(results);
	setEstimateWarning(true);
} 
function setReceiveResults(results) {
	var rx_results = document.getElementById("rx_results");
	if (rx_results) { rx_results.innerHTML = results; }
}
function setTransmitResults(results) {
	var tx_results = document.getElementById("tx_results");
	if (tx_results) { tx_results.innerHTML = results; }
}
function testBegin(form) {
	test_in_progress = true;
	var o = document.getElementById("runtest");
	if (o) { o.disabled = true; }
	setDisabled(form.dst_addr_select, true);
	setDisabled(form.dst_addr_input, true);
	setDisabled(form.port, true);
	setDisabled(form.direction, true);
	setDisabled(form.auth_user, true);
	setDisabled(form.auth_password, true);
	setDisabled(form.launcher_port, true);
	setDisabled(form.time_limit, true);
	setDisabled(form.byte_limit, true);
	setDisabled(form.show_adv, true);
	setEstimateWarning(false);
	setConnectionWarning(false);
	setAuthenticationWarning(false);

	setReceiveResults("<blink>...<\/blink>");
	setTransmitResults("<blink>...<\/blink>");
}
function testStarted(form)
{
	testBegin(form);
}
function testEnd(form) {
	var o = document.getElementById("runtest");
	if (o) { o.disabled = false; o.focus();}
	setDisabled(form.dst_addr_select, false);
	if (iplist) { iplist.triggerManual() };
	setDisabled(form.direction, false);
	setDisabled(form.auth_user, false);
	setDisabled(form.auth_password, false);
	setDisabled(form.launcher_port, false);
	setDisabled(form.time_limit, false);
	setDisabled(form.byte_limit, false);
	setDisabled(form.show_adv, false);
	test_in_progress = false;
}

/* returns true end reached or can't continue end was implicitly reached */
function testStopped(form, direction, begin, end, httpRequest) {
	var rc = -255;
	var rx = speedtest_l10n_na;
	var tx = speedtest_l10n_na;
	var results;

	try {
		if (httpRequest && httpRequest.status == 200) {
			results = httpRequest.responseText.split('|');
			if (results.length > 0) {
				rc = parseInt(results[0]);
			}
		}
	} catch (e) { //just eat exception if any 
	}

	if (rc == 0 && results.length == 3) {
		rx = results[1];
		tx = results[2];
	}
	else if (!icmp_mode && begin)
	{
		icmp_mode = true;
		if (results[0] == -10)
		{
			setAuthenticationWarning(true);
		}
		return false; // Need to perform icmp mode.
	} 
	else
	{
		end = true;
	}
	if (rc == 0 && results.length == 4 && begin) {
		var r = results[3].split(',');
		var val = (r.length > 2) ? r[2] : r[0];
		setEstimateResults(val);
	} else {
		if (rc < 0)
		{
			setConnectionWarning(true);
		}
		if (direction == 'receive' || direction == 'both' || (begin && end))
		{
			setReceiveResults(rx);
		}
		if (direction == 'transmit' || direction == 'both' || (begin && end))
		{
			setTransmitResults(tx);
		}		
	}
	if (end) {
		testEnd(form);
	}
	return end;
}

function performTest(form) {
	setReceiveResults(speedtest_l10n_na);
	setTransmitResults(speedtest_l10n_na);
	
	if (!initTest(form))
	{
		return false;
	}

	testStarted(form);
		
	performTestPass(form, 1);
}

function getDirection(form, pass) {
	var direction;
	if (advanced) {
		direction = form.direction.options[form.direction.selectedIndex].value;
		if (pass == 1)
		{
			if (direction == "duplex")
			{
				return "both";
			}
			if (direction != "both")
			{
				return direction;
			}
		}
		else if (direction != "both")
		{
			return null;
		}
	}
	if (pass == 1) {
		return "receive";
	} else if (pass == 2) {
		return "transmit";
	}
	return null;
}

function initTest(form)
{
	var dst_addr_select = form.dst_addr_select.options[form.dst_addr_select.selectedIndex].value;
	var dst_addr_input = form.dst_addr_input.value;
	var auth_user = form.auth_user.value;
	var auth_password = form.auth_password.value;
	var launcher_port = form.launcher_port.value;
	var time_limit = advanced ? form.time_limit.value : "10";
	var byte_limit = advanced ? form.byte_limit.value : "";
	var query_string;
	
	icmp_mode = false;

	if (dst_addr_select == "0" && dst_addr_input.length == 0)
	{
		return false;
	}

	url="speedtest_action.cgi";
	query_string = "dst_addr_select="+dst_addr_select;
	query_string = query_string + "&dst_addr_input="+dst_addr_input;
	query_string = query_string + "&auth_user="+auth_user;
	query_string = query_string + "&auth_password="+auth_password;
	query_string = query_string + "&launcher_port="+launcher_port;
	query_string = query_string + "&time_limit="+time_limit;
	query_string = query_string + "&bytes_limit="+byte_limit;
	url = url+"?"+query_string;

	return true;
}

function getTestUrl(direction)
{
	return url + "&direction="+direction+"&action=test&sid="+Math.random();
}

function getICMPTestUrl()
{
	return url + "&action=icmptest&sid="+Math.random();
}

var conn = null;

function performTestPass(form, pass) {
	var begin = (pass == 1); 

	if (conn)
	{
		conn.abort();
	}
	else
	{
		conn = new ajax();		
	}

	var direction = getDirection(form, pass);

	var test_url = (icmp_mode ? getICMPTestUrl() : getTestUrl(direction));
	if (!conn.get(test_url,
			function(httpRequest) {
				if (!testStopped(form, direction, begin, 
					(getDirection(form, pass + 1) == null || icmp_mode),
					httpRequest))
				{
					if (!icmp_mode)
					{
						++pass;
					}
					performTestPass(form, pass);
				}
			} ))
	{
		testStopped(form, direction, begin, true, null);
	}
}

function setAdvancedVisible(visible) {
	var i;
	for (i = 1; i <= 5; ++i)
	{
		var advanced = document.getElementById("advanced"+i);
		if (advanced) {
			advanced.style.display = (visible ? "" : "none");
		}
	}
}

function toggleAdvanced(adv) {
	advanced = !advanced;
	setAdvancedVisible(advanced);
}
