#ifndef __STATUS_COMMON_H
#define __STATUS_COMMON_H

#if (defined(PX2) || defined(PX4))
#define WIRELESS_IFACE "wlan0"
#define LAN_IFACE "eth1"
#define BR_IFACE "eth0"
#else
#define WIRELESS_IFACE "ath0"
#define LAN_IFACE "eth0"
#define BR_IFACE "br0"
#define PPPOE_IFACE "ppp0"
#endif

#define WLAN_IFACE WIRELESS_IFACE

#define __MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define __MACSTR "%02X:%02X:%02X:%02X:%02X:%02X"

#define ARRAYSIZE(x) (sizeof(x) / sizeof((x)[0]))

typedef struct dev_status {
	char ifname[IFNAMSIZ];
	unsigned char mac[6];
	struct in_addr addr;
	char ipaddr[18];
	char exists;
	unsigned int flags;
	unsigned int rx_bytes;
	unsigned int rx_packets;
	unsigned int rx_errors;
	unsigned int rx_dropped;
	unsigned int tx_bytes;
	unsigned int tx_packets;
	unsigned int tx_errors;
	unsigned int tx_dropped;
} dev_status_t;

typedef struct antenna {
	int diversity;
	int rx;
	int tx;
	int ext;
        char name[16];
} antenna_t;

typedef struct wlan_info {
	char essid[40];
	unsigned char apmac[6];
	unsigned char mode; /* 0 - undefined, 1 - sta, 2 - ap */

	unsigned int countrycode;
	unsigned char channel;
	unsigned int frequency;
	unsigned int acktimeout;

	char security[32];
	char wmm_level[32];

	float rx_rate;
	float tx_rate;

	char rstatus;
	char signal;
	char noisef;

	int ccq;

	/* errors */
	unsigned int rx_nwids;
	unsigned int rx_crypts;
	unsigned int rx_frags;
	unsigned int tx_retries;
	unsigned int missed_beacons;
	unsigned int other_errors;
        antenna_t antenna;
} wlan_info_t;

typedef struct ls_status {
	int uptime;

	dev_status_t lan;
	dev_status_t br;
	dev_status_t wlan;
	dev_status_t ppp;
	wlan_info_t winfo;
	int show_dhcpc_tool;
} ls_status_t;

#endif // __STATUS_COMMON_H
