#define _GNU_SOURCE
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>

#include <ctype.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <net/if.h>
#include "common.h"

extern int fill_link_stats(const char* ifname, wlan_info_t* status);
extern int fill_wireless_info(const char* ifname, wlan_info_t* status);
extern int print_wstalist(const char* ifname, const char* mac);
extern int ipscan_main(void);
extern int webping_main(int argc, char* const argv[]);


#define STATUS2STR(s, m) \
	__MAC2STR((s)->lan.mac), m ? (m) : (s)->lan.ipaddr, \
	__MAC2STR((s)->wlan.mac), m ? (m) : (s)->wlan.ipaddr, \
	(s)->uptime, time(0), \
	escape((s)->winfo.essid), __MAC2STR((s)->winfo.apmac), \
	(s)->winfo.channel, (s)->winfo.frequency, \
	(s)->winfo.rstatus, (s)->winfo.signal, (s)->winfo.noisef, (s)->winfo.tx_rate, (s)->winfo.rx_rate, \
	(s)->winfo.security, (s)->winfo.wmm_level, \
	(s)->winfo.rx_nwids, (s)->winfo.rx_crypts, (s)->winfo.rx_frags, (s)->winfo.tx_retries, \
	(s)->winfo.missed_beacons, (s)->winfo.other_errors, \
	((s)->lan.flags & IFF_RUNNING) == 0 ? "OFF" : "ON", \
	(s)->lan.rx_bytes, (s)->lan.rx_packets, (s)->lan.rx_errors, \
	(s)->lan.tx_bytes, (s)->lan.tx_packets, (s)->lan.tx_errors, \
	(s)->wlan.rx_bytes, (s)->wlan.rx_packets, (s)->wlan.rx_errors, \
	(s)->wlan.tx_bytes, (s)->wlan.tx_packets, (s)->wlan.tx_errors, \
	(s)->winfo.antenna.name,\
	(s)->winfo.acktimeout, (s)->winfo.ccq, \
	(s)->ppp.rx_bytes, (s)->ppp.rx_packets, (s)->ppp.rx_errors, \
	(s)->ppp.tx_bytes, (s)->ppp.tx_packets, (s)->ppp.tx_errors, \
        m ? (m) : (s)->ppp.ipaddr, \
	(s)->winfo.mode == 2 ? "ap" : "sta", \
	m ? "bridge" : "router", \
	(s)->show_dhcpc_tool

static const char OUTPUT[] =
	"Content-Type: text/html\r\n\r\n"
	"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\""
	"\"http://www.w3.org/TR/html4/loose.dtd\">\n"
	"<html><head><title>STATUS</title>\n" \
	"<meta http-equiv=\"Expires\" content=\"0\">\n"
	"<meta http-equiv=\"Pragma\" content=\"no-cache\">\n"
	"<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n"
	"<script type=\"text/javascript\" language=\"javascript\">\n"
	"\tlmac=\"" __MACSTR "\"; lip=\"%s\";\n"
	"\twmac=\"" __MACSTR "\"; wip=\"%s\";\n"
	"\tuptime=\"%d\"; date_time=%ld;\n"
	"\tessid=\"%s\"; apmac=\"" __MACSTR "\";\n"
	"\tchannel=%d; frequency=\"%d MHz\";\n"
	"\trstatus=%d;\n"
	"\tsignal=%d; noisef=%d;\n"
	"\ttx_rate=%.1f; rx_rate=%.1f;\n"
	"\tsecurity=\"%s\"; qos=\"%s\";\n"
	"\terr_nwids=%u;err_crypts=%u;err_frags=%u;err_retries=%u;err_beacons=%u;err_misc=%u;\n"
	"\tlan_state=\"%s\";\n"
	"\tlan_rxbytes=%u;lan_rxpackets=%u;lan_rxerrors=%u;\n"
	"\tlan_txbytes=%u;lan_txpackets=%u;lan_txerrors=%u;\n"
	"\twlan_rxbytes=%u;wlan_rxpackets=%u;wlan_rxerrors=%u;\n"
	"\twlan_txbytes=%u;wlan_txpackets=%u;wlan_txerrors=%u;\n"
	"\tantenna=\"%s\";\n"
	"\tack=%u;ccq=%u;\n"
	"\tppp_rxbytes=%u;ppp_rxpackets=%u;ppp_rxerrors=%u;\n"
	"\tppp_txbytes=%u;ppp_txpackets=%u;ppp_txerrors=%u;\n"
	"\tppp_ip=\"%s\";\n"
	"\n"
	"\tparent.setOperationMode('%s', '%s', %d, apmac);\n"
	"\tparent.update_basic(essid,apmac,signal,noisef,frequency,channel,tx_rate,rx_rate,ack);\n"
	"\tparent.update_inet(lip,lmac,wip,wmac);\n"
	"\tparent.update_misc(security, qos, uptime, ccq, date_time);\n"
	"\tparent.update_werrors(err_nwids, err_crypts, err_frags, err_retries, err_beacons, err_misc);\n"
	"\tparent.update_lan(lan_state,lan_rxbytes,lan_rxpackets,lan_rxerrors, lan_txbytes,lan_txpackets,lan_txerrors);\n"
	"\tparent.update_wlan(wlan_rxbytes,wlan_rxpackets,wlan_rxerrors,wlan_txbytes,wlan_txpackets,wlan_txerrors);\n"
	"\tparent.update_antenna(antenna);\n"
	"\tparent.update_ppp(ppp_ip,ppp_rxbytes,ppp_rxpackets,ppp_rxerrors,ppp_txbytes,ppp_txpackets,ppp_txerrors);\n"
	"</script>\n"
	"</head><body></body></html>\n";

#define STATUS2SIGNALSTR(s) (s)->winfo.signal
#define STATUS2NOISESTR(s) (s)->winfo.noisef

static const char SIGNAL_OUTPUT[] =
	"Content-Type: text/html\r\n\r\n%d\n";

static const char SIGNAL_NOISE_OUTPUT[] =
	"Content-Type: text/html\r\n\r\nsignal=%d; noisef=%d;\n";

/*
 Supports only 32 characters max as an input.
 All chars could be escapable.
 */
const char* escape(const char* val)
{
	static const char ESCAPE[] = "`\\\"$";
        static char esc_value[32 * 2];
	size_t len, new_len;
	int i;

	if (val)
	{
		new_len = len = strlen(val);
		for (i = 0; i < len; ++i)
		{
			if (strchr(ESCAPE, val[i]))
			{
				++new_len;
			}
		}
		if (new_len == len || new_len > sizeof(esc_value))
		{
			return val;
		}
		else
		{
			char *pos = esc_value;
			for (i = 0; i < len; ++i)
			{
				if (strchr(ESCAPE, val[i]))
				{
					*pos++ = '\\';
				}
				*pos++ = val[i];
			}
			*pos = '\0';
		}
	}
	return esc_value;
}



static int
get_addr(int fd, dev_status_t* dev) {
        struct ifreq ifr;
        struct sockaddr_in* addr = (struct sockaddr_in*)&ifr.ifr_addr;

        memset(&ifr, 0, sizeof(ifr));
        strncpy(ifr.ifr_name, dev->ifname, IFNAMSIZ);
        if (ioctl(fd, SIOCGIFHWADDR, &ifr) == 0) {
		memcpy(dev->mac, &ifr.ifr_hwaddr.sa_data, 6);
        }

#if (defined(PX2) || defined(PX4))
        if (!strcmp(ifr.ifr_name, WIRELESS_IFACE))
	    strncpy(ifr.ifr_name, "eth0", IFNAMSIZ);
#endif
        if (ioctl(fd, SIOCGIFADDR, &ifr) >= 0) {
                memcpy(&dev->addr, &addr->sin_addr, sizeof(dev->addr));
        }
	snprintf(dev->ipaddr, sizeof(dev->ipaddr), "%s", inet_ntoa(dev->addr));

	if (ioctl(fd, SIOCGIFFLAGS, &ifr) >= 0) {
		dev->flags = ifr.ifr_flags;
	}

	return 0;
}

static int
get_ifstats(dev_status_t* dev, char* line) {
	char *d,*s = line;
	int i;
	unsigned int* vars[] = {
                &dev->rx_bytes,
                &dev->rx_packets,
                &dev->rx_errors,
                &dev->rx_dropped,
                NULL, /* &dev->rx_fifo_errors, */
                NULL, /* &dev->rx_frame_errors, */
                NULL, /* &dev->rx_compressed, */
                NULL, /* &dev->multicast, */
                &dev->tx_bytes,
                &dev->tx_packets,
                &dev->tx_errors,
                &dev->tx_dropped,
                NULL, /* &dev->tx_fifo_errors, */
                NULL, /* &dev->collisions, */
                NULL, /* &dev->tx_carrier_errors, */
                NULL, /* &dev->tx_compressed */
	};

	for (i = 0; i < ARRAYSIZE(vars); i++)
	{
		unsigned int value = 0;
		while (isspace(*s)) s++;

		if ((d = strchr (s,' ')) != NULL)
			*d++ = '\0';

		value = strtoul(s, 0, 0);
		if (vars[i] != NULL)
			*vars[i] = value;

		s = d;
	}

	return 0;
}

static inline int
get_procnetdev(dev_status_t** devs) {
	FILE* f;
	char line[255];

	f = fopen("/proc/net/dev", "r");
	if (!f) {
		return -1;
	}
	/* skip header lines */
	if (!fgets(line, sizeof(line), f) || !fgets(line, sizeof(line), f)) {
		fclose(f);
		return -1;
	}

	while (!feof(f) && fgets(line, sizeof(line), f) != NULL) {
		char* s;
	        char* d;
		int i;
		dev_status_t* dev = NULL;
		s = d = line;
		/* TODO: safeguards */
		while (isspace(*s)) s++;
		if ((d = strchr(s, ':')) == NULL)
			continue;
		*d++ = '\0';

		for (i = 0; devs[i] != NULL; ++i) {
			if (strcmp(devs[i]->ifname, s) == 0) {
				dev = devs[i];
				break;
			}
		}
		if (dev != NULL) {
			dev->exists = 1;
			get_ifstats(dev, d);
		}
	}

	fclose(f);
	return 0;
}

static inline int
fill_dev_info(ls_status_t* status) {
        int fd;
	int i;
	dev_status_t* devs[] = {
		&status->lan,
		&status->br,
		&status->wlan,
		&status->ppp,
		NULL,
	};

	get_procnetdev(devs);

        fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);
        if (fd < 0) {
                return 0;
        }

	for (i = 0; devs[i] != NULL; ++i) {
		if (devs[i]->exists) {
			get_addr(fd, devs[i]);
		}
	}

        close(fd);

	return 0;
}

static inline int
fill_misc_info(ls_status_t* status) {
	static const char UPTIME[] = "/proc/uptime";
	char line[255];
	FILE* f;

	status->uptime = 0;

	f = fopen(UPTIME, "r");
	if (!f) {
		return -1;
	}

	if (fgets(line, sizeof(line), f)) {
		sscanf(line, "%d.%*s ", &status->uptime);
	}

	fclose(f);
	return 0;
}

static int fill_dhcpc_tool_info(ls_status_t* status)
{
	static const char* cfg_file = "/tmp/system.cfg";
	struct stat st;
	FILE *f;
	char buf[1024];
	int dhcpc_enabled = 0;
	int dhcpc_1_enabled = 0;
	char* key;
	char* val;
	int len;
	status->show_dhcpc_tool = 0;
	
	memset(&st, 0, sizeof(st));
	if (stat(cfg_file, &st)) 
	{
		/* error on stat */
		return 0;
	}
	if (st.st_mode == (S_IFREG | S_IRWXU | S_IRWXG | S_IRWXO))
	{
		/* permission show that cfg file is modified */
		/* 0100777 */
		return 0;
	}
	f = fopen(cfg_file, "r");
	if (!f)
	{
		/* can't open config file */
		return 0;		
	}
	
	while (fgets(buf, sizeof(buf), f))
	{
		if (*buf == '#' || *buf == '\n' || *buf == '\r' || !(val = strchr(buf, '=')))
		{
			continue;
		}
		len = val - buf;
		buf[len] = '\0';
		
		for (key = buf; *key && (isblank(*key) || !isprint(*key)); ++key)
		; /* Empty Scope */		
		for (len = strlen(key) - 1; len >= 0 && (isblank(key[len]) || !isprint(key[len])); --len)
		{
			 key[len] = '\0';
		}
		if (!*key)
		{
			continue;
		}		
		
		for (++val; *val && (isblank(*val) || !isprint(*val)); ++val)
		; /* Empty Scope */		
		for (len = strlen(val) - 1; len >= 0 && (isblank(val[len]) || !isprint(val[len])); --len)
		{
			 val[len] = '\0';
		}
		if (!*val)
		{
			continue;
		}		
		if (strcmp(key, "dhcpc.status") == 0 && strcmp(val, "enabled") == 0)
		{
			dhcpc_enabled = 1;
		}
		else if (strcmp(key, "dhcpc.1.status") == 0 && strcmp(val, "enabled") == 0)
		{
			dhcpc_1_enabled = 1;
		}
	}
	fclose(f);
	if (dhcpc_enabled && dhcpc_1_enabled)
	{
		status->show_dhcpc_tool = 1;
	}
	return 0;	
}

int
main(int argc, char* const argv[]) {
	ls_status_t status;
	const char* s = argv[0];
	const char* exec = s;
	char* ip;

	memset(&status, 0, sizeof(status));

	for (s = argv[0]; *s != '\0';)
		if (*s++ == '/')
			exec = s;

	if (exec && strncmp(exec, "signal.cgi", 10) == 0) {
		fill_link_stats(WIRELESS_IFACE, &status.winfo);
		fprintf(stdout, SIGNAL_NOISE_OUTPUT, STATUS2SIGNALSTR(&status), STATUS2NOISESTR(&status));
		return 0;
	}
	else if (exec && strncmp(exec, "wstalist", 8) == 0) {
		const char* iface = WIRELESS_IFACE;
		const char* mac = NULL;
		unsigned char mac_addr[6];
		
		if (argc > 1)
		{
			iface = argv[1];
		}
		if (argc > 2)
		{
			if(sscanf(argv[2], "%hhx:%hhx:%hhx:%hhx:%hhx:%hhx",
				&mac_addr[0], &mac_addr[1], &mac_addr[2],
				&mac_addr[3], &mac_addr[4], &mac_addr[5]) == 6)
			{
				mac = mac_addr;
			}
		}
		return print_wstalist(iface, mac);
	}
	else if (exec && strncmp(exec, "ipscan.cgi", 10) == 0) {
		return ipscan_main();
	}
	else if (exec && strcmp(exec, "webping") == 0) {
		return webping_main(argc, argv);
	}

	strncpy(status.br.ifname, BR_IFACE, sizeof(status.br.ifname));
	strncpy(status.lan.ifname, LAN_IFACE, sizeof(status.lan.ifname));
	strncpy(status.wlan.ifname, WLAN_IFACE, sizeof(status.wlan.ifname));
	strncpy(status.ppp.ifname, PPPOE_IFACE, sizeof(status.ppp.ifname));

	fill_dev_info(&status);
	fill_wireless_info(WIRELESS_IFACE, &status.winfo);
	fill_misc_info(&status);
	fill_dhcpc_tool_info(&status);

#if (defined(PX2) || defined(PX4))
	if (status.br.addr.s_addr == 0) {
                memcpy(&(status.br), &(status.lan), sizeof(status.lan));
	    	ip = status.br.ipaddr;
	}
#else
	if (memcmp(status.br.mac, "\x00\x00\x00\x00\x00\x00", 6))
		ip = status.br.ipaddr;
#endif
	else
		ip = NULL;

	fprintf(stdout, OUTPUT, STATUS2STR(&status, ip));

	return 0;
}
