#!/sbin/cgi
<?
include("lib/settings.inc");
$cfg = @cfg_load($cfg_file);
include("lib/l10n.inc");
include("lib/link.inc");

$wmode = w_get_mode($wlan_iface);

if ($feature_ap_scan != 1) {
	if ($wmode == 3) {
		include("lib/err_scan.tmpl");
		exit;
	}
}

Function getReturnCode $cmd_code
(
    $res = (($cmd_code & 65280) / 256);
    if ($res > 127)
    {
	$res -= 256;
    }
    return $res;
);

$entry_regexp="([[:print:]]+)#([[:print:]]*)#([[:print:]]+)#([[:print:]]*)#([[:print:]]+)#([[:print:]]+)#([[:print:]]+)#([[:print:]]*)#\"([[:print:]]*)\"$";

$chanlist_active = file("/proc/sys/net/"+$wlan_iface+"/chanlist_active");
$chans =  $chanlist_active[0];

include("lib/survey_head.tmpl");
flush();

if ($wmode == 3) {
    /* calculate time needed for scan - each channel about 0.2-0.3s */
    $sleep_time=((0+$chanlist_active[1]) / 4) + 1;
    $scan = Exec("exec /usr/etc/apscan.sh " + $sleep_time + " " + $wlan_iface + "| sort -n", $arr, $result);
} else {
    /* run scan & output results now */
    $scan = Exec("iwlist "+$wlan_iface+" scan | " + $cmd_scanparser + "| sort -n", $arr, $result);
};

if ($result != 0);
    echo "<tr><td colspan=\"8\">" + dict_translate("Scanning failed") + "</td></tr>";
    include("lib/survey_tail.tmpl");
    exit;
else;
    UnSet($values);

    $i = 0;
    $size = count($arr);

    while ($i < $size);
        if (ereg($entry_regexp, $arr[$i], $res));
	    $mac = $res[1];
	    $ssid = htmlspecialchars($res[9]);
	    $freq = $res[3];
	    $chan = $res[4];
		if ($radio1_ccode_locked) {
			$freq = get_freq($radio1_ccode, $chan);
		} else {
			$freq = $res[3];
		}
	    $enc = $res[8];
	    if ($enc == "none") {
	      $enc = "-";
	    }
	    echo "<tr>";
	    if ($mode != "tool");
		    echo "<td><input type=\"radio\" name=\"ssid\" value=\""+$mac+"#"+$enc+"#"+$ssid + "\"></td>";
	    else;
		    echo "<td>&nbsp;</td>";
	    endif;
	    echo "<td class=\"str\">" + $mac + "</td>";
	    echo "<td class=\"str\">" + $ssid + "</td>";
	    echo "<td>" + strtoupper($enc) + "</td>";
	    echo "<td>" + $res[6] + "</td>";
	    echo "<td>" + $res[7] + "</td>";
	    echo "<td>" + $freq + "</td>";
	    echo "<td>" + $chan + "</td>";
	    echo "</tr>\n";
	endif;

        $i++;
    endwhile;
endif;

include("lib/survey_tail.tmpl");

>
