/*
 * depends on:
 *     ajax.js
 *     util.js
 *
 * TODO: cache elements instead of querying them everytime
 */
function IPList(selectId,inputId,refreshImgId) {
	this.selectId = selectId;
	this.inputId = inputId;
	this.imgId = refreshImgId;
	this.started = false;
	this.conn = null;
	var me = this;

	this.refreshStarted = function() {
	
		var r = document.getElementById(me.selectId);
		if (r) setDisabled(r, true);	
		r = document.getElementById(me.imgId);
		if (r) { r.src='FULL_VERSION_LINK/images/loading.gif'; }
		me.started = true;
	}
	this.refreshStopped = function() {
		var r = document.getElementById(me.selectId);
		if (r) setDisabled(r, false);	
		r = document.getElementById(me.imgId);
		if (r) { r.src='FULL_VERSION_LINK/images/refresh.gif'; }
		me.started = false;
	}
	this.triggerManual = function() {
		var s = document.getElementById(me.selectId);
		setDisabled(document.getElementById(me.inputId), (s.selectedIndex != 0));
	}
	this.update = function() {
		if (me.started) {
			return false;
		}
		me.refreshStarted();
		if (this.conn)
		{
			this.conn.abort();
		}
		else
		{
			this.conn = new ajax();
		}
		var s = document.getElementById(me.selectId);

		var oldVal = s.options[s.selectedIndex];
		if (!this.conn.get('ipscan.cgi?a='+new Date().getTime(),
			function(req) {
				var o = document.getElementById(me.selectId);
				if (o) {
					o.length = 0;
					addOption(o, jsTranslate('input manually'), '0');
					if (req.status == 200) {
						var ips = req.responseText.split("\n");
						for (i = 0; i < ips.length; ++i) {
							var ip = ips[i];
							if (ip.length > 0) {
								addOption(o, ip, ip);
							}
						}
					}
					selectOption(o, oldVal.value);
				}
				me.refreshStopped();
			})) {
			me.refreshStopped();
		}
		
		return true;
	}

	this.update();
	this.triggerManual();

	var s = document.getElementById(this.selectId);
	s.onchange = this.triggerManual;
	s = document.getElementById(this.imgId);
	s.onclick = this.update;

	return this;
}
