#
# build system variables
#
ifndef CONFDIR
CONFDIR := $(BUILDDIR)/conf/current
endif

#
# Architecture specifics
#
ARCH=mips
build_toolchain_dir=/opt/toolchain/mips_ls
build_toolchain_prefix=$(build_toolchain_dir)/bin/mips-linux-
build_kernel_version=linux-kernel-2.4
build_kernel_directory=$(BUILDDIR)/kernel/${build_kernel_version}

export ARCH build_toolchain_dir build_toolchain_prefix build_kernel_version build_kernel_directory


#
# Product specifics
#
PRODUCT=xs2
PRODUCT_VERSION=XS2.ar2316.v3.6
PRODUCT_KERNEL_CFG=$(CONFDIR)/linux-kernel-2.4.config
PRODUCT_BUSYBOX_CFG=$(CONFDIR)/busybox.config

export PRODUCT PRODUCT_VERSION

#
# Applications
#
DRIVERS := ar531x-gpio ar2313-enet madwifi-5.0 devint
APPS_OPEN := zlib libevent
APPS_GPL := matrixssl php2 boa busybox udhcp dnsmasq scanparser \
	    ppp tinysnmp iptables ebtables \
	    wireless-tools hostapd-0.6.3 wpasupplicant-0.6.3 \
	    iproute2  trigger_url ntpclient igmpproxy dropbear
#	    bird batmand wifidog
#APPS_GPL += libpcap tcpdump iperfi

export DRIVERS APPS_OPEN APPS_GPL

#
# Extra options
#
MADWIFI_HAL_BUS=AHB
MADWIFI_HAL_TARGET=mipsisa32-be-elf-ls2

export MADWIFI_HAL_BUS MADWIFI_HAL_TARGET

### CUT HERE ###
UBNTBOX:=y
APPS_CLOSED := ubntbox mcagent
DRIVERS := devint ath_hal_50 $(DRIVERS)

export UBNTBOX APPS_CLOSED DRIVERS
