/**
 * Dummy DFS callbacks, just to make the driver happy
 * Or glue code to link with external binary module
 **/

/* This should match the table from if_ath.c */
enum {
	ATH_DEBUG_DFS		= 0x00000200,	/* Minimal DFS debug */
	ATH_DEBUG_DFS1		= 0x00000400,	/* Normal DFS debug */
	ATH_DEBUG_DFS2		= 0x00000800,	/* Maximal DFS debug */
};

struct dfs_event {
	STAILQ_ENTRY(dfs_event)	re_list;	/* List of radar events */
};

struct ath_dfs {
	int16_t			dfs_curchan_radindex;	/* cur. channel radar index */
	STAILQ_HEAD(,dfs_event) dfs_arq;	/* Q of AR events */
	STAILQ_HEAD(,dfs_event)	dfs_radarq;	/* Q of radar events */
};


#if !AH_SUPPORT_DFS
inline struct dfs_state*
dfs_getchanstate(struct ath_softc *sc, u_int8_t *index)
{
	return	NULL;
}


inline int
dfs_process_radarevent(struct ath_softc *sc, HAL_CHANNEL *chan)
{
	return 0;
}


inline u_int32_t
dfs_check_nol(struct ath_softc *sc, HAL_CHANNEL *chans, u_int32_t nchans)
{
	return 0;
}


inline int
dfs_attach(struct ath_softc *sc)
{
	return 0;
}

inline int dfs_re_attach(struct ath_softc *sc)
{
        return 0;
}


inline void
dfs_detach(struct ath_softc *sc)
{ }

inline void
ath_ar_enable(struct ath_softc *sc)
{ }


inline int dfs_radar_enable(struct ath_softc *sc)
{
	return 0;
}


inline void
ath_ar_disable(struct ath_softc *sc)
{}

inline void
ath_process_phyerr(struct ath_softc *sc, struct ath_desc *ds, u_int64_t fulltsf)
{ }

inline void
dfs_process_ar_event(struct ath_softc *sc, HAL_CHANNEL *chan)
{ }


inline int
ath_ioctl_phyerr(struct ath_softc *sc, struct ath_diag *ad)
{
	return -EINVAL;
}


inline int
dfs_get_thresholds(struct ath_softc *sc, HAL_PHYERR_PARAM *param)
{
	return 0;
}
#else
	/**
	 * DFS is compiled as external binary module
	 **/

extern int	dfs_attach(struct ath_softc *sc);
extern int	dfs_re_attach(struct ath_softc *sc);
extern void dfs_detach(struct ath_softc *sc);
extern void ath_ar_enable(struct ath_softc *sc);
extern void	ath_ar_disable(struct ath_softc *sc);
extern int dfs_radar_enable(struct ath_softc *sc);
extern struct dfs_state *dfs_getchanstate(struct ath_softc *sc,
					  u_int8_t *index);
extern int dfs_process_radarevent(struct ath_softc *sc, HAL_CHANNEL *chan);
extern u_int32_t dfs_check_nol(struct ath_softc *sc, HAL_CHANNEL *chans,
			       u_int32_t nchans);
extern void ath_process_phyerr(struct ath_softc *sc, struct ath_desc *ds,
			       u_int64_t fulltsf);
extern void dfs_process_ar_event(struct ath_softc *sc, HAL_CHANNEL *chan);
extern int	dfs_set_thresholds(struct ath_softc *sc, const u_int32_t threshtype,
			      const u_int32_t value);
extern int	dfs_get_thresholds(struct ath_softc *sc, HAL_PHYERR_PARAM *param);
extern int	ath_ioctl_phyerr(struct ath_softc *sc, struct ath_diag *ad);

#endif	//	AH_SUPPORT_DFS
