/**
 * Module glue code to link with GPL
 **/

#include <linux/config.h> 
#include <linux/version.h> 
#include <linux/module.h> 
#include <linux/init.h> 
#include <linux/slab.h>
#include "sys/queue.h"
#include <linux/netdevice.h> 

#include <net80211/if_media.h>
#include <net80211/ieee80211_var.h>
#include "if_athvar.h"
#include "dfs.h"



static char *dev_info = "ath_dfs";
int domainoverride=0;
int usenol=1;

MODULE_AUTHOR("Atheros Communications, Inc.");
MODULE_DESCRIPTION("DFS Support for Atheros 802.11 wireless LAN cards.");
MODULE_SUPPORTED_DEVICE("Atheros WLAN cards");
#ifdef MODULE_LICENSE
MODULE_LICENSE("Proprietary");
#endif

MODULE_PARM(domainoverride, "i");
MODULE_PARM_DESC(domainoverride, "Override dfs domain");
MODULE_PARM(usenol, "i");
MODULE_PARM_DESC(usenol, "Override the use of channel NOL");


static int __init
init_ath_dfs(void)
{
	printk (KERN_INFO "%s: Version 2.0.0\n"
		"Copyright (c) 2005-2006 Atheros Communications, Inc. "
		"All Rights Reserved\n",dev_info);
	return 0;
}
module_init(init_ath_dfs);

static void __exit
exit_ath_dfs(void)
{
	printk (KERN_INFO "%s: driver unloaded\n", dev_info);
}
module_exit(exit_ath_dfs);

int	OS_PRINTF(const char *fmt, ...)
{
	return printk(fmt);
}

void *OS_MALLOC(size_t size)
{
	return kmalloc(size, GFP_KERNEL);
}

void OS_FREE(const void * data)
{
	kfree(data);
}

void* OS_MEM_ZERO(void * data, size_t size)
{
	return memset(data, 0, size);
}



EXPORT_SYMBOL(dfs_attach);
EXPORT_SYMBOL(dfs_detach);
EXPORT_SYMBOL(dfs_re_attach);
EXPORT_SYMBOL(ath_ar_enable);
EXPORT_SYMBOL(ath_ar_disable);
EXPORT_SYMBOL(dfs_radar_enable);
EXPORT_SYMBOL(dfs_getchanstate);
EXPORT_SYMBOL(dfs_process_radarevent);
EXPORT_SYMBOL(ath_process_phyerr);
EXPORT_SYMBOL(dfs_process_ar_event);
EXPORT_SYMBOL(ath_ioctl_phyerr);
EXPORT_SYMBOL(dfs_check_nol);
EXPORT_SYMBOL(dfs_get_thresholds);

