/*-
 * Copyright (c) 2007 UBT
 * All rights reserved.
 */
 
/*
 * Defintions for UBT software packet error recovery (SPER).
 */
#ifndef _DEV_UBT_SPER_H
#define _DEV_UBT_SPER_H

#ifdef	USE_NSTREAM

#include "if_ethersubr.h"                                                                  
#include "ah.h"
#include "if_llc.h"
#include "net80211/ieee80211.h"         /* XXX for WME_NUM_AC */
                                                                                
#define	SPER_RXBUF           32	/* number of RX buffers */
#define	SPER_TXBUF           32	/* number of TX buffers */
#define	SPER_TX_MAX          8  /* Maximum number of outstanding Tx packets */
#define	SPER_RETRY_MAX       5  /* Maximum Retransmission number based on PLM */
#define	SPER_RETX_NUM        2  /* Maximum Retransmission number each period. */
#define	SPER_MAX_BUF         32	/* Maximum number of buffers */
#define	SPER_MAX_BUF1        31	/* SPER_MAX_BUF -1 */
#define SPER_MAX_SEQ      65536 /* should be 2^n */
#define SPER_MAX_SEQ1     65535 /* should be 2^n-1 */
#define NR_BUFS ((MAX_SEQ + 1)/2
typedef unsigned short sper_seq_nr;     /* sequence or ack numbers */
typedef enum {sper_false, sper_true} sper_boolean;  /* boolean type */

typedef struct {
   char ad_name[IFNAMSIZ];
   unsigned short ad_id;
   unsigned short ad_in_size;
   char * ad_in_data;
   char * ad_out_data;
   unsigned int ad_out_size; 
} SPER_DIAG_PAR;

enum {
      SPER_SUCCESS  = 0,
      SPER_SKB_ERR  = 1,
      SPER_REG_READ_ERR  = 2,
      SPER_REG_WRITE_ERR  = 3,
      SPER_WLL_LINK_ERR  = 4,
      SPER_WLL_PWR_SAVE  = 5
};

/* frame_kind definition */
typedef enum {
  sper_data, 
  sper_ack, 
  sper_retry
} sper_frame_kind;

/* Send frame status */
typedef enum {
  SPER_NO_DATA,
  SPER_QUEUED_FOR_TX, 
  SPER_WAIT_FOR_ACK,
  SPER_TX_ERROR
} sper_frame_tx_state;

/* Timer states */
typedef enum {
  sper_timer_init, 
  sper_timer_added, 
  sper_timer_running
} sper_timer_status;

#define	SPER_802_11_HDR	  30   /* length of ieee802.11 header */
#define	SPER_LLC_HDR	   8   /* length of LLC header*/
#define	SPER_SPER_HDR	  12   /* length of software packet error recovery protocol header*/
#define	SPER_CHECK_SUM	  4    /* length of ieee802.11 check sum*/
#define	SPER_DATA_SAP	  0x11 /* dsap and ssap for data pdu*/

/* The command field has two bytes. Currently only the first four
   bits, b3 b2 b1 b0, of the first byte are used.*/
#ifdef __BIG_ENDIAN
#define	SPER_CMD_ACK_ONLY       0x200 /* ACK only pdu*/
#define	SPER_CMD_ACK_WITH_DATA	0x300 /* ACK plus data pdu*/
#define	SPER_CMD_DATA_BIT       0x100 /* the bit indicates a data pdu is included */
#define	SPER_CMD_ACK_BIT        0x200 /* the bit indicates ACK info is included */
#define	SPER_CMD_INIT_BIT       0x400 /* the bit indicates it's the 1st pkt */
#define	SPER_CMD_PLM_BIT        0x800 /* the bit indicates PLM is included */
#else
#define	SPER_CMD_ACK_ONLY       0x2 /* ACK only pdu*/
#define	SPER_CMD_ACK_WITH_DATA	0x3 /* ACK plus data pdu*/
#define	SPER_CMD_DATA_BIT       0x1 /* the bit indicates a data pdu is included */
#define	SPER_CMD_ACK_BIT        0x2 /* the bit indicates ACK info is included */
#define	SPER_CMD_INIT_BIT       0x4 /* the bit indicates it's the 1st pkt */
#define	SPER_CMD_PLM_BIT        0x8 /* the bit indicates PLM is included */
#endif

#define	SPER_TXRETRY_TIME   10  /* 0.01s*/
#define	SPER_ACK_TIME_OUT    2  /* 0.002s*/
#define	SPER_TURN_AROUND   3000  /* unit: us should be based on packet length and rate*/
#define	SPER_TURN_AROUND_DELTA   5000  /* unit: us*/

#define	sper_inc(no) no=(no+1)&(0xFFFF)

/* packet descriptor. */
typedef struct {
    struct sk_buff *skb;   /* skbuff for buf */
    struct net_device *dev; /* network device used to send /receive packet. */
    u_int16_t ssn;  /* send sequence number*/
    u_int16_t pai;  /* packet arrival information*/
    u_int16_t cnt;  /* retry count */
    u_int16_t sst;  /* send state */
    u_int32_t time;   /* send/receive time */
} sper_buf;

struct sper_header {
  u_int8_t  dsap; /* dest service access point */
  u_int8_t  ssap; /* source service access point */
  u_int16_t ssn;  /* send sequence number*/
  u_int16_t rsn;  /* received sequence number*/
  u_int16_t cmd;  /* command field*/
  u_int32_t   plm;  /* packet loss map */
}__packed;
typedef struct sper_header *sper_phdr;

struct sper_plm_info {
  struct sper_header  sper; /* the SPER header with PLM */
  struct net_device *dev; /* network device used to send /receive packet. */
  u_int32_t   time;  /* packet arrival time. */
  u_int32_t   handle; /* need to handle PLM or not. */
};
typedef struct sper_plm_info *sper_plm_pinfo;

/* Timer and related information. */
typedef struct {
    struct timer_list timer;   /* kernel timer structur */
    sper_timer_status status; /* Is the timer running? */
    struct ether_header eh; /* Save the ethernet header for possible re-transmit. */
    struct net_device *dev;
} sper_timer;

int sper_do_ack(int enable, struct net_device *dev);
int sper_init(struct net_device *dev);
int sper_deinit(struct net_device *dev);
int sper_frame_arrival(struct ieee80211_node *ni, struct sk_buff *);
void sper_rx_loop_end( void);
int sper_update_tstamp(struct sk_buff *skb, unsigned int tsf);
int sper_hardstart(struct sk_buff *skb, struct net_device *dev);

#endif	//	USE_NSTREAM

#endif /* _DEV_UBT_SPER_H */
