#ifndef	__MYDEBUG_H__
#define	__MYDEBUG_H__

#define MAC2STR(a) (a)[0], (a)[1], (a)[2], (a)[3], (a)[4], (a)[5]
#define MACSTR "%02x:%02x:%02x:%02x:%02x:%02x"

#define MYDEBUG(args...)    do { \
        printk("madwifi.%s():\t", __FUNCTION__); \
        printk(args); \
        printk("\n"); \
    } while(0)


#define MYDEBUGVALd(arg)    MYDEBUG("%s = %d", #arg, arg)
#define MYDEBUGVALx(arg)    MYDEBUG("%s = 0x%08x", #arg, arg)

#define MYDEBUGVALmac(arg)  MYDEBUG("%s = %02x:%02x:%02x:%02x:%02x:%02x", \
			#arg, arg[0], arg[1], arg[2], arg[3], arg[4], arg[5])

#define MYDEBUGVALbuf(s, b, l)  do { \
        int i, j; \
        printk("madwifi.%s.%s:\n", __FUNCTION__, s); \
        for (i=0;  i<(l/16);  ++i) { \
            for( j=0;  j<16; ++j) \
                printk("%02x ", b[i*16+j]); \
            printk("\n"); \
        } \
        for( j=0;  j<(l%16); ++j) \
            printk("%02x ", b[(l & ~0x0f) + j]); \
        printk("\n\n"); \
    } while(0)

#define	MYTRACE()	printk("%s\t%s()\t[%4d]\n", __FILE__, __func__, __LINE__)
#define	TRACE		MYTRACE

#endif	// __MYDEBUG_H__
