#include <string.h>
#include <libgen.h>

extern int wlanconfig_main(int argc, char* argv[]);
extern int a80211debug_main(int argc, char* argv[]);
extern int a80211stats_main(int argc, char* argv[]);
extern int athchans_main(int argc, char* argv[]);
extern int athctrl_main(int argc, char* argv[]);
extern int athdebug_main(int argc, char* argv[]);
extern int athkey_main(int argc, char* argv[]);
extern int athstats_main(int argc, char* argv[]);

int
main(int argc, char* argv[]) {
    char* tool;
    int rc = 0;

    tool = basename(argv[0]);

    if(strcmp(tool, "wlanconfig") == 0)
        rc = wlanconfig_main(argc, argv);

    if(strcmp(tool, "80211stats") == 0 || strcmp(tool, "wlanstats") == 0)
        rc = a80211stats_main(argc, argv);
    if(strcmp(tool, "athchans") == 0)
        rc = athchans_main(argc, argv);
    if(strcmp(tool, "athctrl") == 0)
        rc = athctrl_main(argc, argv);
    if(strcmp(tool, "athkey") == 0)
        rc = athkey_main(argc, argv);
    if(strcmp(tool, "athstats") == 0)
        rc = athstats_main(argc, argv);
 
    if(strcmp(tool, "80211debug") == 0 || strcmp(tool, "wlandebug") == 0)
        rc = a80211debug_main(argc, argv);
    if(strcmp(tool, "athdebug") == 0)
        rc = athdebug_main(argc, argv);

    return rc;
}
