/*
 *  coyote-pci.c
 *
 *  Copyright (C) 2002 Jungo Software Technologies.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#include <linux/pci.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/config.h>

#include <asm/mach/pci.h>
#include <asm/arch/irqs.h>
#include <asm/arch/pci.h>
#include <asm/arch/gpio.h>
#include <asm/arch/pci.h>
#include <asm/arch/ixp425.h>

#define PCI_FIRST_SLOT          14
#define IXP425_PCI_MAX_DEV      2
#define IXP425_PCI_IRQ_LINES    2

#ifdef CONFIG_IXP425_WX5715_PCI
#define INTA    IRQ_IXP425_GPIO10
#define INTB    IRQ_IXP425_GPIO11
#define INTA_PIN	IXP425_GPIO_PIN_10
#define INTB_PIN	IXP425_GPIO_PIN_11
#undef INTC
#undef INTD


#else /* CONFIG_IXP425_WX5715_PCI */
#ifdef CONFIG_IXP425_AP1000_PCI

#define INTA	IRQ_IXP425_GPIO11
#define INTB	IRQ_IXP425_GPIO10
#define INTA_PIN	IXP425_GPIO_PIN_11
#define INTB_PIN	IXP425_GPIO_PIN_10
#define INTC	IRQ_IXP425_GPIO9
#define INTD	IRQ_IXP425_GPIO8
#define INTC_PIN	IXP425_GPIO_PIN_9
#define INTD_PIN	IXP425_GPIO_PIN_8

#undef IXP425_PCI_MAX_DEV
#undef IXP425_PCI_IRQ_LINES
#define IXP425_PCI_MAX_DEV      4
#define IXP425_PCI_IRQ_LINES    4

#else /* CONFIG_IXP425_AP1000_PCI */

#define INTA	IRQ_IXP425_GPIO11
#define INTB	IRQ_IXP425_GPIO6
#define INTA_PIN	IXP425_GPIO_PIN_11
#define INTB_PIN	IXP425_GPIO_PIN_6
#undef INTC
#undef INTD

#endif /* CONFIG_IXP425_AP1000_PCI */
#endif /* CONFIG_IXP425_WX5715_PCI */

/* PCI controller pin mappings */
#ifdef CONFIG_IXP425_WX5715_PCI

#define IXP425_PCI_RESET_GPIO   IXP425_GPIO_PIN_13
#define IXP425_PCI_CLK_PIN      IXP425_GPIO_CLK_1
#define IXP425_PCI_CLK_ENABLE   IXP425_GPIO_CLK1_ENABLE
#define IXP425_PCI_CLK_TC_LSH   IXP425_GPIO_CLK1TC_LSH
#define IXP425_PCI_CLK_DC_LSH   IXP425_GPIO_CLK1DC_LSH

#define CONFIG_PCI_RESET	/* enable pci reset ? */
#undef RESET_PCI_CLOCK		/* stop/start pci clock on reset */

#else /* CONFIG_IXP425_WX5715_PCI */

#ifdef CONFIG_IXP425_AP1000_PCI

#define IXP425_PCI_RESET_GPIO   IXP425_GPIO_PIN_13
#define IXP425_PCI_CLK_PIN      IXP425_GPIO_CLK_0
#define IXP425_PCI_CLK_ENABLE   IXP425_GPIO_CLK0_ENABLE
#define IXP425_PCI_CLK_TC_LSH   IXP425_GPIO_CLK0TC_LSH
#define IXP425_PCI_CLK_DC_LSH   IXP425_GPIO_CLK0DC_LSH

#undef CONFIG_PCI_RESET	/* enable pci reset ? */
#undef RESET_PCI_CLOCK		/* stop/start pci clock on reset */

#else /* CONFIG_IXP425_AP1000_PCI */

#define IXP425_PCI_RESET_GPIO   IXP425_GPIO_PIN_12
#define IXP425_PCI_CLK_PIN      IXP425_GPIO_CLK_0
#define IXP425_PCI_CLK_ENABLE   IXP425_GPIO_CLK0_ENABLE
#define IXP425_PCI_CLK_TC_LSH   IXP425_GPIO_CLK0TC_LSH
#define IXP425_PCI_CLK_DC_LSH   IXP425_GPIO_CLK0DC_LSH

#define CONFIG_PCI_RESET	/* enable pci reset ? */
#undef RESET_PCI_CLOCK		/* stop/start pci clock on reset */

#endif /* CONFIG_IXP425_AP1000_PCI */
#endif /* CONFIG_IXP425_WX5715_PCI */

#ifdef CONFIG_PCI_RESET

void __init coyote_pci_hw_init(void)
{
	/*
	u32 csr,csr2;

	printk("Doing PCI RESET ...\n");

	csr = *PCI_CSR;
	csr2 = csr | PCI_CSR_HOST | PCI_CSR_ARBEN;
	printk("PCI_CSR was: %08X, now: %08X\n",csr,csr2);
	*PCI_CSR=csr2;
	*/

	printk("PCI: Resetting PCI bus...\n");

#ifdef RESET_PCI_CLOCK
 /* Disable PCI clock */
 *IXP425_GPIO_GPCLKR &= ~IXP425_PCI_CLK_ENABLE;

 /* configure PCI-related GPIO */
 gpio_line_config(IXP425_PCI_CLK_PIN, IXP425_GPIO_OUT);
#endif

 gpio_line_config(IXP425_PCI_RESET_GPIO, IXP425_GPIO_OUT);

 gpio_line_config(INTA_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);
 gpio_line_config(INTB_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);

 gpio_line_isr_clear(INTA_PIN);
 gpio_line_isr_clear(INTB_PIN);

#ifdef CONFIG_IXP425_AP1000_PCI
 gpio_line_config(INTC_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);
 gpio_line_config(INTD_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);

 gpio_line_isr_clear(INTC_PIN);
 gpio_line_isr_clear(INTD_PIN);
#endif /* CONFIG_IXP425_AP1000_PCI */

 /* Assert reset for PCI controller */
 gpio_line_set(IXP425_PCI_RESET_GPIO, IXP425_GPIO_LOW);
 /* wait 1ms to satisfy "minimum reset assertion time" of the PCI spec. */
 udelay(10000);
#ifdef RESET_PCI_CLOCK
 /* Config PCI clock */
 *IXP425_GPIO_GPCLKR |=
   (0xf << IXP425_PCI_CLK_TC_LSH) | (0xf << IXP425_PCI_CLK_DC_LSH);
 /* Enable PCI clock */
 *IXP425_GPIO_GPCLKR |= IXP425_PCI_CLK_ENABLE;
 /* wait 100us to satisfy "minimum reset assertion time from clock stable"
  * requirement of the PCI spec. */
 udelay(10000);
#endif
 /* Deassert reset for PCI controller */
 gpio_line_set(IXP425_PCI_RESET_GPIO, IXP425_GPIO_HIGH);

 /* wait a while to let other devices get ready after PCI reset */
 udelay(10000);
 udelay(10000);
 udelay(10000);
 udelay(10000);
 udelay(10000);

 udelay(10000);
 udelay(10000);
 udelay(10000);
 udelay(10000);
 udelay(10000);
}

#endif

void __init coyote_pci_init(void *sysdata)
{
#ifdef CONFIG_IXP425_WX5715_PCI
	printk("PCI: Using GPIO layout for WX5715 board\n");
#else
#ifdef CONFIG_IXP425_AP1000_PCI
	printk("PCI: Using GPIO layout for AP1000 board\n");
#else
	printk("PCI: Using GPIO layout for ADI board\n");
#endif 
#endif

#ifdef CONFIG_PCI_RESET
 if (ixp425_pci_is_host())
   coyote_pci_hw_init();
#endif

 gpio_line_config(INTA_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);
 gpio_line_config(INTB_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);

 gpio_line_isr_clear(INTA_PIN);
 gpio_line_isr_clear(INTB_PIN);

#ifdef CONFIG_IXP425_AP1000_PCI
 gpio_line_config(INTC_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);
 gpio_line_config(INTD_PIN, IXP425_GPIO_IN | IXP425_GPIO_ACTIVE_LOW);

 gpio_line_isr_clear(INTC_PIN);
 gpio_line_isr_clear(INTD_PIN);
#endif /* CONFIG_IXP425_AP1000_PCI */

 ixp425_pci_init(sysdata);
}

static int __init coyote_map_irq(struct pci_dev *dev, u8 slot, u8 pin)
{

	static int pci_irq_table[IXP425_PCI_MAX_DEV][IXP425_PCI_IRQ_LINES] =
	{
#if defined(INTC) && defined(INTD)
		{INTA, INTB, INTC, INTD},
		{INTB, INTC, INTD, INTA},
		{INTC, INTD, INTA, INTB},
		{INTD, INTA, INTB, INTC}
#else
		{INTB, INTB},
		{INTA, INTA}
#endif
	};

	int irq = -1;

//	printk("coyote_map_irq: slot=%d, pin=%d\n", slot, pin);

	if (slot >= PCI_FIRST_SLOT) slot = (slot - PCI_FIRST_SLOT) + 1;

	if (slot >= 1 && slot <= IXP425_PCI_MAX_DEV &&
		pin >= 1 && pin <= IXP425_PCI_IRQ_LINES)
	{
		irq = pci_irq_table[slot-1][pin-1];
	}

//	printk("coyote_map_irq: irq=%d\n", irq);

	return irq;
}

struct hw_pci coyote_pci __initdata = {
 init:   coyote_pci_init,
 swizzle:  common_swizzle,
 map_irq:  coyote_map_irq,
};


