/************************************************************************

        (c) COPYRIGHT 1995-2004, Wistron Nexus, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Wistron Nexus,
     Inc.. No part of this software may be reproduced, stored
     , transmitted, disclosed or used in any form or by any means
     other than as provided by the written License Agreement between
     Wistron Nexus, Inc. and its Licensee.

                         Wistron Nexus, Inc.
                          Hsinchu, Taiwan

************************************************************************/

/************************************************************************

    Desc:       C file for count CRC utility

    File:       gen_zImage.c

    Revision History:

                When        Who         What
                2003/05     David       First Release

************************************************************************/

#include <stdio.h>
#include <string.h>

#define TYPE_KERNEL 1
#define MARK_HEAD   0x12345678
#define MARK_TAIL   0x87654321

typedef struct _Header
{
    unsigned int   head;           //0x12345678   
    unsigned char  BoardID[64];
    unsigned int   Type;
    unsigned int   ImgLength;
    unsigned int   CRC;
    unsigned char  Reserved[44];
    unsigned int   tail;           //0x87654321
}Header, * PHeader;

char    szDefBoardAP[64]     = "RA801.S0B IDT 79RC32333 11g Wireless AP\0";
char    szDefBoardRouter[64] = "RR801.S0B IDT 79RC32438 11g Wireless Router\0";
char    szDefBoardSwitch[64] = "RS801.S0B IDT 79RC32438 11g Wireless Switch\0";

#define BLOCK_SIZE     16384

/************************************************************************
*   Main Program
*
*   Note: Configuration utility function dispatched here!
************************************************************************/

int main(int argc, char *argv[])
{
    char * szInFile;
    char szOutFile[256]="zImage";
    unsigned int crcValue=0;
    unsigned int nFileSize=0;
    
    unsigned char Buf[BLOCK_SIZE];
    PHeader  pHeader;
    unsigned int nBlockCnt;
    unsigned int nRestByte;
    unsigned int i,j;
    unsigned int offsetCRC;
    
    FILE * hInFile;  // Output message file!
    FILE * hOutFile; // Output message file!    
    
    printf("+-------------------------------------------------------------+\n");
    printf("+ Firmware Header Generate Utility, by David 2003 May  22     +\n");
    printf("+-------------------------------------------------------------+\n");

    switch (argc) {
        case 1: 
            printf("no argument!\n");
            printf("Ex: gzImage zImage_noelf zImage\n");
            printf("Please execute again!\n");
            break;
        case 3: // 2 argument, 1st as input filename , 2nd as output file name!"            
            strcpy( szOutFile , argv[2] );
        case 2: // one , as input file name, output use default"zImage"!
        {
            szInFile = argv[1];            
            printf("Infile : %s\n",szInFile);
            printf("Outfile: %s\n",szOutFile);
            // Execute CRC....
                
            hInFile =  fopen(szInFile,"r");
            hOutFile = fopen(szOutFile, "w+");
            
            fseek(hInFile,0L, SEEK_END);
            nFileSize = ftell(hInFile);
//-------------------------------------------------------
// Fill in CRC Header....
            pHeader = (PHeader) Buf;
            pHeader->head = MARK_HEAD;           //0x12345678  
            strcpy(pHeader->BoardID, szDefBoardSwitch);
            pHeader->Type = TYPE_KERNEL;
            pHeader->ImgLength = nFileSize;
            pHeader->CRC = 0;
            memset(pHeader->Reserved, 0, 44);  // all set to zero              
            pHeader->tail = MARK_TAIL;           //0x87654321
// Write CRC Header....
            fwrite(pHeader, sizeof(Header),  1, hOutFile);
//------------------------------------------------------- 
            fseek(hInFile,0L, SEEK_SET);
            
            nBlockCnt = nFileSize / BLOCK_SIZE;
            nRestByte = nFileSize % BLOCK_SIZE;

            for (i =0; i< nBlockCnt;i++) {
                fread ( Buf, BLOCK_SIZE, 1, hInFile);
                for (j=0; j< BLOCK_SIZE; j++)
                    crcValue += Buf[j];
                fwrite( Buf, BLOCK_SIZE, 1, hOutFile);
            }
            // Last Block!
            if (nRestByte) {
                fread ( Buf, nRestByte, 1, hInFile);
                for (j=0; j< nRestByte; j++)
                    crcValue += Buf[j];
                fwrite( Buf, nRestByte, 1, hOutFile);
            }
            printf("  FileLength (noelf) = 0x%08X ( %d Bytes )\n",nFileSize, nFileSize);
            printf("  Checksum   (CRC)   = 0x%08X\n",  crcValue );
//-----------------Write back CRC Value -----------------                                   
            offsetCRC = (unsigned char *)&pHeader->CRC - (unsigned char *)&pHeader->head;
            fseek(hOutFile, offsetCRC, SEEK_SET);
            fwrite( &crcValue, 1, sizeof(unsigned int), hOutFile);
            printf("Write File \'%s\' successfully!\n", szOutFile);            
//-------------------------------------------------------            
            fclose(hInFile);
            fclose(hOutFile);
        }
        default: break;
    }
    printf("\n");
    return 0;
}

