/* 
 * Cryptographic API.
 *
 * CCMP Cipher Algorithm.
 *
*/

#include <linux/module.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/errno.h>
#include <linux/crypto.h>
#include <asm/byteorder.h>

#define CCMP_MIN_KEY_SIZE	16
#define CCMP_MAX_KEY_SIZE	32

#define CCMP_BLOCK_SIZE		1

struct ccmp_ctx {
	int key_length;
};

static int
ccmp_set_key(void *ctx_arg, const u8 *in_key, unsigned int key_len, u32 *flags)
{
	struct ccmp_ctx *ctx = ctx_arg;

	if (key_len != 16 && key_len != 24 && key_len != 32) {
		*flags |= CRYPTO_TFM_RES_BAD_KEY_LEN;
		return -EINVAL;
	}

	ctx->key_length = key_len;

	return 0;
}

static void ccmp_encrypt(void *ctx_arg, u8 *out, const u8 *in)
{
	printk("ccmp_encrypt: unexpected call to software algo!\n");
}

static void ccmp_decrypt(void *ctx_arg, u8 *out, const u8 *in)
{
	printk("ccmp_decrypt: unexpected call to software algo!\n");
}


static struct crypto_alg ccmp_alg = {
	.cra_name		=	"ccmp",
	.cra_flags		=	CRYPTO_ALG_TYPE_CIPHER,
	.cra_blocksize		=	CCMP_BLOCK_SIZE,
	.cra_ctxsize		=	sizeof(struct ccmp_ctx),
	.cra_module		=	THIS_MODULE,
	.cra_list		=	LIST_HEAD_INIT(ccmp_alg.cra_list),
	.cra_u			=	{
		.cipher = {
			.cia_min_keysize	=	CCMP_MIN_KEY_SIZE,
			.cia_max_keysize	=	CCMP_MAX_KEY_SIZE,
			.cia_setkey	   	= 	ccmp_set_key,
			.cia_encrypt	 	=	ccmp_encrypt,
			.cia_decrypt	  	=	ccmp_decrypt
		}
	}
};

static int __init ccmp_init(void)
{
	return crypto_register_alg(&ccmp_alg);
}

static void __exit ccmp_fini(void)
{
	crypto_unregister_alg(&ccmp_alg);
}

module_init(ccmp_init);
module_exit(ccmp_fini);

MODULE_DESCRIPTION("CCMP Cipher Algorithm");
MODULE_LICENSE("Dual BSD/GPL");

