#include "IxQMgr.h"
#include "IxNpeDl.h"
#include "IxOsServices.h"
#include "ixp425.h"
#include "IxOsCacheMMU.h"
#include "IxCryptoAcc.h"
#include "ix_ossl.h"
#include <linux/config.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/completion.h>
#include <asm/semaphore.h>
#include "ixp4xx.h"
#include "ixp4xx_ll.h"
#include "IxTypes.h"

/** Bits in byte */
#define BITS_IN_BYTE    8

//#define DEBUG 1

/** Registration results  */
volatile int register_context = 0;

void ixp4xx_register_callback (
        UINT32 cryptoCtxId,
        IX_MBUF *pMbuf, 
        IxCryptoAccStatus status)
{
//	struct ixp4xx_crypto_context* icc = 0;
//	
//	if (pMbuf && pMbuf->priv) 
//		icc = pMbuf->priv;
	register_context = 1;
	printk("ixp4xx_register_callback: status = %d\n", status);

	/* We are expecting two callbacks for authentication and combined service 
	 * The pMbuf could be null for encrypt/decrypt ONLY operation.
	 */
	if (NULL != pMbuf)
	{
		/* Must return the buffer to the pool irrespective of the status */
		printk("got mbuf, don't know what to do!\n");
		//        ixCryptoAccCodeletCryptoMbufToQTailAdd (pMbuf);
	}

	if (IX_CRYPTO_ACC_STATUS_SUCCESS == status)
	{
#if 0
		if (!icc) { 
			printk(KERN_ERR "h/w request crypto context is NULL.\n");
			BUG();
		} 

		icc->callback = 1;
#endif
	}
	else 
	{
		if (IX_CRYPTO_ACC_STATUS_WAIT == status)
		{
			ixOsServLog(LOG_MESSAGE, 
				    "Register not completed yet; Context %d\n", 
				    cryptoCtxId, 
				    0, 0, 0, 0, 0);
		}
		else
		{
			ixOsServLog(LOG_WARNING, "Registration failed; Context %d\n", 
				    cryptoCtxId, 0, 0, 0, 0, 0);
		}
	} /* End of if else (IX_CRYPTO_ACC_STATUS_SUCCESS == status) */
} /* End of ixCryptoAccCodeletRegisterCB () function */


void ixp4xx_perform_callback(
        UINT32 cryptoCtxId,
        IX_MBUF *pSrcMbuf, 
        IX_MBUF *pDestMbuf,
        IxCryptoAccStatus status)
{
	struct ixp4xx_crypto_context* icc = 0;

	if (pSrcMbuf)
		icc = pSrcMbuf->priv;

	if (!icc) { 
		printk(KERN_ERR "h/w request crypto context is NULL.\n");
		BUG();
	} else {
		if (icc->completion) 
			complete(icc->completion);

		icc->callback = 1;
	}

	switch (status)
	{
	case IX_CRYPTO_ACC_STATUS_SUCCESS:
#if 0
		if (pSrcMbuf) {
			printk(KERN_DEBUG "src->data: %p, src->len: %d\n",
			       pSrcMbuf->m_data, pSrcMbuf->m_len); 

			if (pSrcMbuf->m_data && pSrcMbuf->m_len)
				hex_dump(pSrcMbuf->m_data, pSrcMbuf->m_len);
		} else {
			printk(KERN_DEBUG "pSrcMbuf is NULL\n");
		}

		printk(KERN_DEBUG "ixp4xx_perform_callback: success\n");
#endif
		break;
      
	case IX_CRYPTO_ACC_STATUS_AUTH_FAIL:
		ixOsServLog(LOG_WARNING, "Authentication Failed\n",
			    0, 0, 0, 0, 0, 0);
		break;

	case IX_CRYPTO_ACC_STATUS_FAIL:
		ixOsServLog(LOG_WARNING, "Operation Failed\n", 
			    0, 0, 0, 0, 0, 0);
		break;

	default:
		ixOsServLog(LOG_ERROR, "Error in status message, %d\n", 
			    status, 0, 0, 0, 0, 0);
    }
}


void ixp4xx_ctx_init(IxCryptoAccCtx * cryptoAccCtx)
{
	memset(cryptoAccCtx, 0, sizeof(*cryptoAccCtx));

	cryptoAccCtx->operation = IX_CRYPTO_ACC_OP_TYPE_OF_OPERATION;
	cryptoAccCtx->cipherCtx.cipherAlgo = IX_CRYPTO_ACC_CIPHER_NULL;
	cryptoAccCtx->cipherCtx.cipherMode = IX_CRYPTO_ACC_MODE_NULL ;
	cryptoAccCtx->cipherCtx.cipherKeyLen = 0;
	cryptoAccCtx->cipherCtx.key.desKey[0] = 0;
	cryptoAccCtx->cipherCtx.cipherBlockLen = 0;
	cryptoAccCtx->cipherCtx.cipherInitialVectorLen = 0;
	cryptoAccCtx->authCtx.authAlgo =IX_CRYPTO_ACC_AUTH_NULL;
	cryptoAccCtx->authCtx.authDigestLen = 0;
	cryptoAccCtx->authCtx.authKeyLen = 0;
	cryptoAccCtx->authCtx.key.authKey[0] =  0;
	cryptoAccCtx->useDifferentSrcAndDestMbufs = FALSE;
}


int ixp4xx_register_cipher_ctx(struct ixp4xx_cipher_context* ctx, int enc, 
		int * pCtxId, IxCryptoAccCtx *pCtx)

{
	IxCryptoAccStatus status ;

	ixp4xx_ctx_init(pCtx);

	if (enc)
		pCtx->operation = IX_CRYPTO_ACC_OP_ENCRYPT;
	else
		pCtx->operation = IX_CRYPTO_ACC_OP_DECRYPT;

	switch (ctx->mode & ENC_MODE_MASK) {
		case ENC_MODE_CBC:
			pCtx->cipherCtx.cipherMode = IX_CRYPTO_ACC_MODE_CBC;
			break;
		case ENC_MODE_ECB:
			pCtx->cipherCtx.cipherMode = IX_CRYPTO_ACC_MODE_ECB;
			break;
		case ENC_MODE_CTR:
			pCtx->cipherCtx.cipherMode = IX_CRYPTO_ACC_MODE_CTR;
			break;
		default:
			printk("Unsupported cipher mode! (%d)\n", ctx->mode & ENC_MODE_MASK);
			return -EINVAL;	
	}
			
	switch (ctx->mode & ENC_ALGO_MASK) {
		case ENC_ALGO_AES:
			pCtx->cipherCtx.cipherAlgo = IX_CRYPTO_ACC_CIPHER_AES;
			break;
		case ENC_ALGO_DES:
			pCtx->cipherCtx.cipherAlgo = IX_CRYPTO_ACC_CIPHER_DES;
			break;
		case ENC_ALGO_3DES:
			pCtx->cipherCtx.cipherAlgo = IX_CRYPTO_ACC_CIPHER_3DES;
			break;
		case ENC_ALGO_ARC4:
			pCtx->cipherCtx.cipherAlgo = IX_CRYPTO_ACC_CIPHER_ARC4;
			/* fixup cipher mode - it is different for ARC4 */
			if (enc)
				pCtx->operation = 0x01;
			else
				pCtx->operation = 0x00;

			break;
		default:
			printk("Unsupported algo! (%d)\n", ctx->mode & ENC_ALGO_MASK);
			break;
	}

	pCtx->cipherCtx.cipherKeyLen = ctx->keylen;
	pCtx->cipherCtx.cipherBlockLen = ctx->blocksize;
	pCtx->cipherCtx.cipherInitialVectorLen = ctx->blocksize;

	memcpy (pCtx->cipherCtx.key.cipherKey, ctx->key, ctx->keylen);

	pCtx->useDifferentSrcAndDestMbufs = FALSE;

	/* Register the context, as a note , primary and secondory mbuf's are 
	 * used internally for a variables chaining & so on. For encryption &
	 * decryption these are not used, so they are NULL.
	 */
	status = ixCryptoAccCtxRegister(pCtx, 
					NULL,	/* primary mbuf used for chaining */
					NULL, 	/* secondary mbuf used for chaining. */
					ixp4xx_register_callback, 
					ixp4xx_perform_callback, 
					pCtxId);

	if (IX_CRYPTO_ACC_STATUS_SUCCESS != status) {
		printk ("Context registration Failed. Status = %d\n", status);
		return IX_FAIL;
	} else {
#if 0
		struct ixp4xx_crypto_context ctx = {0, 0, 0};
		ixp4xx_crypto_wait(&ctx);
#endif

		/* butt ugly hack ... */
		while (!register_context);

		if (!register_context) {
			printk("Timeout waiting for RegisterCB\n");
			return -EINVAL;
		}

		register_context = 0;
	}


	return 0;
}

int ixp4xx_register_ccmp_ctx(struct ixp4xx_cipher_context* ctx, int enc, 
		int * pCtxId, IxCryptoAccCtx *pCtx)

{
	IxCryptoAccStatus status ;

	ixp4xx_ctx_init(pCtx);

	if (enc)
		pCtx->operation = IX_CRYPTO_ACC_OP_ENCRYPT_AUTH;
	else
		pCtx->operation = IX_CRYPTO_ACC_OP_AUTH_DECRYPT;

	pCtx->cipherCtx.cipherMode = IX_CRYPTO_ACC_MODE_CCM;
	pCtx->cipherCtx.cipherAlgo = IX_CRYPTO_ACC_CIPHER_AES;
	pCtx->cipherCtx.cipherKeyLen = IX_CRYPTO_ACC_AES_KEY_128;
	memcpy(pCtx->cipherCtx.key.aesKey128, ctx->key, 16);
	pCtx->cipherCtx.cipherBlockLen =   IX_CRYPTO_ACC_AES_BLOCK_128;
	pCtx->cipherCtx.cipherInitialVectorLen = IX_CRYPTO_ACC_AES_CCM_IV_512;

    pCtx->authCtx.authAlgo = IX_CRYPTO_ACC_AUTH_CBC_MAC;                       
	pCtx->authCtx.authDigestLen = IX_CRYPTO_ACC_CCM_DIGEST_64;                 
	pCtx->authCtx.authKeyLen = 0;                                              
	pCtx->authCtx.aadLen = 48;                                                 

	pCtx->useDifferentSrcAndDestMbufs = TRUE;

	/* Register the context, as a note , primary and secondory mbuf's are 
	 * used internally for a variables chaining & so on. For encryption &
	 * decryption these are not used, so they are NULL.
	 */
	status = ixCryptoAccCtxRegister(pCtx, 
					NULL,	/* primary mbuf used for chaining */
					NULL, 	/* secondary mbuf used for chaining. */
					ixp4xx_register_callback, 
					ixp4xx_perform_callback, 
					pCtxId);

	if (IX_CRYPTO_ACC_STATUS_SUCCESS != status) {
		printk ("Context registration Failed. Status = %d\n", status);
		return IX_FAIL;
	} else {
#if 0
		struct ixp4xx_crypto_context ctx = {0, 0, 0};
		ixp4xx_crypto_wait(&ctx);
#endif

		/* butt ugly hack ... */
		while (!register_context);

		if (!register_context) {
			printk("Timeout waiting for RegisterCB\n");
			return -EINVAL;
		}

		register_context = 0;
	}


	return 0;
}


int ixp4xx_setkey(struct ixp4xx_cipher_context* ctx)
{
	int CtxId;
	IxCryptoAccCtx Ct;
	int ret;

#ifdef DEBUG
	/* Useless debug for now, the same information is presented via setkey(8) */
	int i;

	printk("ixp4xx_setkey: mode = %d, keylen = %d, blocksize = %d\n",
			ctx->mode, ctx->keylen, ctx->blocksize);
	printk("ixp4xx_setkey: key = ");
	for (i=0; i<ctx->keylen;i++) 
		printk("%02X ", ctx->key[i]);
	printk("\n");

#endif

	/* register forward and reverse contexts */

	if ((ret=ixp4xx_register_cipher_ctx(ctx, 1, &CtxId, &Ct))) {
		printk ("Failed to register context! (ret=%d)\n", ret);
		return ret;
	}
	ctx->enc_CtxId = CtxId; /* forward */

	if ((ret=ixp4xx_register_cipher_ctx(ctx, 0, &CtxId, &Ct))) {
		printk ("Failed to register forward context! (ret=%d)\n", ret);
		return ret;
	}
	ctx->dec_CtxId = CtxId; /* reverse */
	
//	printk(KERN_DEBUG "ixp4xx_setkey: enc_ctxid = %d, dec_ctxid = %d\n",
//			ctx->enc_CtxId, ctx->dec_CtxId);
	return 0;
}

int ixp4xx_ccmp_hw_setkey(struct ixp4xx_cipher_context* ctx)
{
	int CtxId;
	IxCryptoAccCtx Ct;
	int ret;

	/* register forward and reverse contexts */

	if ((ret=ixp4xx_register_ccmp_ctx(ctx, 1, &CtxId, &Ct))) {
		printk ("Failed to register context! (ret=%d)\n", ret);
		return ret;
	}
	ctx->enc_CtxId = CtxId; /* forward */

	if ((ret=ixp4xx_register_ccmp_ctx(ctx, 0, &CtxId, &Ct))) {
		printk ("Failed to register forward context! (ret=%d)\n", ret);
		return ret;
	}
	ctx->dec_CtxId = CtxId; /* reverse */
	
	return 0;
}

int ixp4xx_unsetkey(struct ixp4xx_cipher_context* ctx)
{
	int ret;

//	printk("ixp4xx_unsetkey\n");

	ret = ixCryptoAccCtxUnregister(ctx->enc_CtxId);
	if (ret) 
		printk("Failed to unregister forward context! (ret=%d)\n", ret);

	ret = ixCryptoAccCtxUnregister(ctx->dec_CtxId);
	if (ret) 
		printk("Failed to unregister reverse context! (ret=%d)\n", ret);

	return 0;
}

/**********************************************************************************
 *
 *	ixp4xx_cipher
 *
 **********************************************************************************/


int ixp4xx_cipher(struct ixp4xx_cipher_context* ctx, struct scatterlist *dst, 
		struct scatterlist *src, unsigned int nbytes, int enc, 
		const u8* iv)
{
	DECLARE_COMPLETION(completion);
	struct ixp4xx_crypto_context icc = { ctx, 0, 0 };
	IX_MBUF* mbuf;
	UINT32 CtxId = IX_CRYPTO_ACC_MAX_ACTIVE_SA_TUNNELS;
	IxCryptoAccStatus status ;
	int ret = 0;

#ifdef DEBUG
	printk("ixp4xx_cipher: mode = %d, keylen = %d, blocksize = %d\n",
			ctx->mode, ctx->keylen, ctx->blocksize);
	printk("ixp4xx_cipher: key = ");
	for (i=0; i<ctx->keylen;i++) 
		printk("%02X ", ctx->key[i]);
	printk("\n");
#endif
	if (enc)
		CtxId = ctx->enc_CtxId;
	else
		CtxId = ctx->dec_CtxId;

	if ( (page_address(src->page)+src->offset) != 
			(page_address(dst->page)+dst->offset) ) {
		printk("ixp4xx_cipher: src and dst must be the same!\n");
		return -EINVAL;
	}

	mbuf = ixp4xx_alloc_mbuf(0);
	if (!mbuf) return -ENOMEM;

	mbuf->m_data = page_address(src->page) + src->offset;
	mbuf->m_len= nbytes;
	mbuf->priv = &icc;

#if 0
	if (iv) {
		memcpy(Mbuf->m_data + nbytes, iv, ctx->blocksize);
		ivoffset = nbytes;
		Mbuf->m_len += ctx->blocksize;
	} else {
		ivoffset = 0;
	}
#endif

	if (!in_interrupt()) 
		icc.completion = &completion;

	if ((ctx->mode & ENC_ALGO_MASK) == ENC_ALGO_ARC4) {
		/* hw accelerator support only 128 bit keylen */
		/* fallback to software if keylen != 16 bytes */
		if (ctx->keylen != 16)
			return -EINVAL;

//		printk("before wep perform\n");
//		ixp4xx_hex_dump(mbuf->m_data, mbuf->m_len);

		status= ixCryptoAccNpeWepPerform(CtxId,
				mbuf,
				NULL,
				0, 
				nbytes,
				nbytes,
				(UINT8  *)ctx->key);

//		printk("after wep perform\n");
//		ixp4xx_hex_dump(mbuf->m_data, mbuf->m_len);


	} else {

		status = ixCryptoAccAuthCryptPerform (CtxId, 
				mbuf, 
				NULL,
				0, 
				0, 
				0,
				nbytes, 
				0, 
				(UINT8  *)iv);
	}

	if (IX_CRYPTO_ACC_STATUS_SUCCESS != status) {
		printk("ixCryptoAccAuthCryptPerform returned %d\n", status);
		ret = -EINVAL;
	} else {
		ixp4xx_crypto_wait(&icc);

		if (!icc.callback) {
			printk("Timeout waiting for PerformCB\n");
			ret = -EINVAL;
		}
	}

#ifdef DEBUG
	if (icc.callback) {

		printk(KERN_DEBUG "after encrypt\n");
		ixp4xx_hex_dump(Mbuf->m_data, Mbuf->m_len);
		// printk("iv:\n");
		//hex_dump((char *)iv, ctx->blocksize);
	}
#endif

	ixp4xx_free_mbuf(mbuf, 0);
	return ret;

}


/**********************************************************************************
 *
 *	ixp4xx_ccmp - separate function because we need both auth and cipher operations
 *
 **********************************************************************************/


int ixp4xx_ccmp(struct ixp4xx_cipher_context* ctx, struct scatterlist *dst, 
		struct scatterlist *src, unsigned int nbytes, int enc, 
		const u8* iv)
{
	DECLARE_COMPLETION(completion);
	struct ixp4xx_crypto_context icc = { ctx, 0, 0 };
	IX_MBUF* in_mbuf, * out_mbuf;
	UINT32 CtxId = IX_CRYPTO_ACC_MAX_ACTIVE_SA_TUNNELS;
	IxCryptoAccStatus status ;
	int ret = 0;

#if 1
	int i;

	printk("ixp4xx_ccmp: keylen = %d, blocksize = %d\n",
			ctx->keylen, ctx->blocksize);
	printk("ixp4xx_ccmp: key = ");
	for (i=0; i<ctx->keylen;i++) 
		printk("%02X ", ctx->key[i]);
	printk("\n");
	printk("ixp4xx_ccmp: iv = ");
	for (i=0; i<64;i++) 
		printk("%02X ", iv[i]);
	printk("\n");
#endif
	if (enc)
		CtxId = ctx->enc_CtxId;
	else
		CtxId = ctx->dec_CtxId;

	in_mbuf = ixp4xx_alloc_mbuf(0);
	if (!in_mbuf) return -ENOMEM;
	out_mbuf = ixp4xx_alloc_mbuf(0);
	if (!out_mbuf) return -ENOMEM;

	in_mbuf->m_data = page_address(src->page) + src->offset;
	in_mbuf->m_len= src->length;
	in_mbuf->priv = &icc;

	out_mbuf->m_data = page_address(dst->page) + dst->offset;
	// out_mbuf->m_len= nbytes+8;
	out_mbuf->m_len= dst->length;
	out_mbuf->priv = &icc;

	if (!in_interrupt()) 
		icc.completion = &completion;

	printk(KERN_DEBUG "ccmp before encrypt\n");
	ixp4xx_hex_dump(in_mbuf->m_data, in_mbuf->m_len);

	status = ixCryptoAccAuthCryptPerform (CtxId, 
					in_mbuf, out_mbuf,
					0, nbytes, 0,
					nbytes, nbytes, (UINT8  *)iv);

	if (IX_CRYPTO_ACC_STATUS_SUCCESS != status) {
		printk("ixCryptoAccAuthCryptPerform returned %d\n", status);
		ret = -EINVAL;
	} else {
		ixp4xx_crypto_wait(&icc);

		if (!icc.callback) {
			printk("Timeout waiting for PerformCB\n");
			ret = -EINVAL;
		}
	}

	if (icc.callback) {
		printk(KERN_DEBUG "ccmp after encrypt\n");
		ixp4xx_hex_dump(out_mbuf->m_data, out_mbuf->m_len);
		// printk("iv:\n");
		//hex_dump((char *)iv, ctx->blocksize);
	}

	ixp4xx_free_mbuf(in_mbuf, 0);
	ixp4xx_free_mbuf(out_mbuf, 0);
	return ret;
}

