/*
 */
#include <linux/config.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/sysrq.h>

#include <linux/fs.h>
#include <linux/proc_fs.h>

#include "ixp4xx_ll.h"

#if defined(CONFIG_MAGIC_SYSRQ)
extern struct ixp4xx_private* instance;

static void ixp4xx_sysrq_handler(int key, struct pt_regs* pt_regs, 
	struct tty_struct *tty)
{
#if 0
	struct ixp4xx_private* p = instance;
	if (p){
	    int i;

	    printk("cmd_idx = %d 0x%08x\n", 0, hifn_read(p, HIFN_DMA_CMD_ADDR));
	    for (i = 0; i <= CMD_DESC_NUM; ++i)
		print_bd(i, &p->cmd_d[i]);

	    printk("src_idx = %d 0x%08x\n", p->src_idx, hifn_read(p, HIFN_DMA_SRC_ADDR));
	    for (i = 0; i <= SRC_DESC_NUM; ++i)
		print_bd(i, &p->src_d[i]);
	    
	    printk("dst_idx = %d 0x%08x\n", 0, hifn_read(p, HIFN_DMA_DST_ADDR));
	    for (i = 0; i <= DST_DESC_NUM; ++i)
		print_bd(i, &p->dst_d[i]);

	    printk("res_idx = %d 0x%08x\n", 0, hifn_read(p, HIFN_DMA_RES_ADDR));
	    for (i = 0; i <= RES_DESC_NUM; ++i)
		print_bd(i, &p->res_d[i]);
	}
#endif
}

static struct sysrq_key_op ixp4xx_sysrq_op = {
	.handler = ixp4xx_sysrq_handler,
	.help_msg = "IXP4XX",
	.action_msg = "Show IXP4XX crypto status",
};
#endif /* CONFIG_MAGIC_SYSRQ */

void __init ixp4xx_debug_init(void){
#if defined(CONFIG_MAGIC_SYSRQ)
	register_sysrq_key('f', &ixp4xx_sysrq_op);
#endif	
}

void __exit ixp4xx_debug_fini(void){    
#if defined(CONFIG_MAGIC_SYSRQ)
	unregister_sysrq_key('f', &ixp4xx_sysrq_op);
#endif
}
	

