/*
 */
#ifndef __IXP4XX_DBG_H_
#define __IXP4XX_DBG_H_

#include <linux/config.h>
#include <linux/types.h>
#include <linux/init.h>

#if defined(CONFIG_CRYPTO_IXP4XX_DEBUG) 
#define DBG_LEVEL 2
void ixp4xx_debug_init(void) __init;
void ixp4xx_debug_fini(void) __exit;
#else
#define DBG_LEVEL 0
#define ixp4xx_debug_init()	((void)0)
#define ixp4xx_debug_fini()	((void)0)
#endif

#if DBG_LEVEL > 0
#  define DBG(f,x...)	printk(KERN_DEBUG "ixp4xx: " f, ##x)
#  define NL		"\n"
#else
#  define DBG(f,x...)	((void)0)
#endif
#if DBG_LEVEL > 1
#  define DBG2(f,x...) 	DBG(f, ##x)
#else
#  define DBG2(f,x...) 	((void)0)
#endif

#endif /* __IXP4XX_DBG_H_ */
