#include <linux/init.h>

#include "IxQMgr.h"
#include "IxNpeDl.h"
#include "IxOsServices.h"
#include "ixp425.h"
#include "IxOsCacheMMU.h"
#include "IxCryptoAcc.h"
#include "ix_ossl.h"
#include "ixp4xx_engine.h"

static IxQMgrDispatcherFuncPtr ixCryptoAccCodeletDispatcherFunc;
static int ixCryptoAccDispatcherStart(void) 
{

	ixQMgrDispatcherLoopGet(&ixCryptoAccCodeletDispatcherFunc);
        if (IX_SUCCESS != ixOsServIntBind (IXP425_INT_LVL_QM1,
                              (IxVoidFnVoidPtr)ixCryptoAccCodeletDispatcherFunc,
                              (void *)IX_QMGR_QUELOW_GROUP))
        {
		return IX_FAIL;
	}

	return IX_SUCCESS;
}

static void ixCryptoAccDispatcherStop(void)
{
   	if (IX_SUCCESS != ixOsServIntUnbind (IXP425_INT_LVL_QM1))
    	{
		printk ("Failed to unbind to QM1 interrupt\n");
    	}
}

int __init ixp4xx_engine_init(void)
{
#if 0
	printk(KERN_INFO "starting ixp4xx crypto glue initialisation.\n");

	printk(KERN_DEBUG "Initializing NPE C...");
	/* Initialise NPE C */
	if (IX_SUCCESS != ixNpeDlNpeInitAndStart (IX_NPEDL_NPEIMAGE_NPEC_CRYPTO_AES_CCM_ETH)) {
		printk (KERN_ERR "Error initialising NPE C for crypto processing\n");
		return IX_FAIL;
	}
	printk("..done\n");

#endif

#if 1
	printk(KERN_DEBUG "Initializing NPE A...");
	/* Initialise NPE A */
	if (IX_SUCCESS != ixNpeDlNpeInitAndStart (IX_NPEDL_NPEIMAGE_NPEA_WEP)) {
		printk (KERN_ERR "Error initialising NPE A for ARC4/WEP processing\n");
		return IX_FAIL;
	}
	printk("..done\n");
#endif
	
#if 0	// no need to initialize - it is already initialized by ixp425_eth
	if (IX_SUCCESS != ixQMgrInit())
	{
		// printk ("Error initialising queue manager!\n");
	}
#endif

	if(IX_SUCCESS != ixCryptoAccConfig(IX_CRYPTO_ACC_CFG_CRYPTO_WEP_NPE_ACC_EN)) {
		printk(KERN_ERR "Error failed to configure crypto acc component");
		return IX_FAIL;
	}

	/* Initialise cryptoAcc component */
	if (IX_CRYPTO_ACC_STATUS_SUCCESS != ixCryptoAccInit()) {
		printk(KERN_ERR "Error initialising Crypto access component!\n");
		//     return IX_FAIL;
	}

	if (IX_SUCCESS != ixCryptoAccDispatcherStart()) {
		printk (KERN_ERR "Error starting queue manager dispatcher!\n");
		return IX_FAIL;
	}

	printk(KERN_INFO "ixp4xx crypto glue initialised.\n");

	return 0;
}
void __exit ixp4xx_engine_stop(void)
{
#if 0
	printk("ixp4xx_wrap fini\n");

	// printk("Stopping NPE C...");
	/* stop NPE C */
	if (IX_SUCCESS != ixNpeDlNpeStopAndReset (IX_NPEDL_NPEID_NPEC)) {
		// printk ("Error stopping NPE C\n");
	} else // printk("..done\n");

#endif
#if 1
	printk("Stopping NPE A...");
	/* stop NPE A */
	if (IX_SUCCESS != ixNpeDlNpeStopAndReset (IX_NPEDL_NPEID_NPEA)) {
		printk ("Error stopping NPE A\n");
	} else printk("..done\n");
#endif

	ixCryptoAccDispatcherStop();

	if (IX_SUCCESS != ixCryptoAccCryptoServiceStop()) {
		printk("Error stopping CryptoService\n");
	}
}
