#include "ixp4xx_ll.h"
#include "IxOsCacheMMU.h"

#define IX_DESCRIPTOR_DATA(x) (IX_XSCALE_CACHE_LINE_SIZE * (((x) + (IX_XSCALE_CACHE_LINE_SIZE -1))/IX_XSCALE_CACHE_LINE_SIZE))

IX_MBUF* ixp4xx_alloc_mbuf(size_t size) 
{
	IX_MBUF* mbuf;
	size_t mbuf_size = IX_DESCRIPTOR_DATA(sizeof(*mbuf));
	mbuf = kmalloc(mbuf_size, in_interrupt() ? GFP_ATOMIC : GFP_KERNEL);
	if (!mbuf) {
		printk(KERN_ERR "Can't allocate memory for descriptor\n");
		return 0;
	}

	memset(mbuf, 0, mbuf_size);

	if (size) {
		mbuf->m_data = kmalloc(IX_DESCRIPTOR_DATA(size), in_interrupt() ? GFP_ATOMIC : GFP_KERNEL);
		if (!mbuf->m_data) {
			kfree(mbuf);	
			mbuf = 0;
		} else {
			mbuf->m_len = size;
		}
	}

	return mbuf;
}

void ixp4xx_free_mbuf(IX_MBUF* mbuf, size_t size)
{
	if (mbuf && size) {
		kfree(mbuf->m_data);
	}

	kfree(mbuf);
}




void ixp4xx_crypto_wait(struct ixp4xx_crypto_context* icc)
{
#ifdef DEBUG
	int i;

	for (i = 0; i < 500; i++) {
		if (!icc->callback)
			break;
		udelay(500);
	}

#else
	if (!icc) {
		printk(KERN_ERR "neither callback nor completion is set.\n");
		BUG();
	}

	/* if using completion port - icc->completion must not zero. */
	if (icc->completion) {
		wait_for_completion(icc->completion);	
	} else if (!icc->callback) {
		/* if using busy wait because we can't schedule() */
		while(!icc->callback);
	} 
	
#endif
}

void ixp4xx_hex_dump(void *buf, int len)
{
    int i;

    for (i = 0 ; i < len; i++)
    {
	printk("%02x", ((u8*)buf)[i]);
	if (i%2)
	    printk(" ");
	if (15 == i%16)
	    printk("\n");
    }
    printk("\n");
}
