/*
 */
#ifndef __IXP4XX_LL_H_
#define __IXP4XX_LL_H_

#include <linux/spinlock.h>
#include <linux/completion.h>
#include <linux/skbuff.h>
#include <linux/completion.h>

#include <asm/types.h>
#include <asm/scatterlist.h>
#include <asm/io.h>

#include "ixp4xx.h"
#include "IxCryptoAcc.h"
#include "IxOsBuffMgt.h"

/* Maximum number of source SG fragments we can process (quite arbitrary actually :) */
#define MAX_SG_COUNT		(MAX_SKB_FRAGS * 4)

/* Maximum result size (I'm being lazy here, chip supports bigger sizes :) */
#define MAX_RESULT_SIZE		0xffff
#define MAX_RESULT_ORDER	4

/* Call status */
#define STATUS_PENDING		0
#define STATUS_OK		1
#define STATUS_ERROR		2

/* current operation (there can only be one at a time) */
#define OP_NONE			0
#define OP_HASH_MD5		1
#define OP_HASH_SHA1		2
#define OP_CIPHER		3

/* Driver instance data */
struct ixp4xx_private {
	spinlock_t		lock;
	int			busy;
	wait_queue_head_t	wq;

	/* current operation context */
	atomic_t*   	    	status;
	struct completion*	completion;

	int 			op;
	void*			op_result;

	/* cipher result */
	struct scatterlist*	dst_sg;
	unsigned int	    	dst_nbytes;

	/* Consistent scratch buffer (HMAC/cipher keys, IVs) */
	u8*			scratch;
	dma_addr_t		scratch_dma;
};

/* Driver specific cipher context */
struct ixp4xx_cipher_context {
	u16 mode;
	u16 keylen;
	u16 blocksize;
	u16 __alignment_dummy;
	u32 enc_CtxId; 		/* context id for encryption */
	u32 dec_CtxId;		/* context id for decryption */
	u8  key[0];
};

/* Driver specific digest context */
struct ixp4xx_digest_context {
	u32  ctxid;		/* context id */
	IxCryptoAccCtx* hwctx;
	u8  key[0];		/* not used yet. */
};

struct ixp4xx_crypto_context {
	void*	context;	/* either cipher or digest context */
	volatile int callback;	/* 0 initial value, 1 - callback is called. */
	struct   completion* completion;
};

void ixp4xx_crypto_wait(struct ixp4xx_crypto_context* icc);

IX_MBUF* ixp4xx_alloc_mbuf(size_t size);
void ixp4xx_free_mbuf(IX_MBUF* mbuf, size_t size);
void ixp4xx_hex_dump(void *buf, int len);
#endif /* __IXP4XX_LL_H_ */
