#ifndef _NET_AH_H
#define _NET_AH_H

#include <net/xfrm.h>
#include <asm/scatterlist.h>

/* This is the maximum truncated ICV length that we know of. */
#define MAX_AH_AUTH_LEN	12

extern int skb_to_sgvec(struct sk_buff *skb, struct scatterlist *sg, int offset, int len);

struct ah_data
{
	u8			*key;
	int			key_len;
	u8			*work_icv;
	int			icv_full_len;
	int			icv_trunc_len;

	void			(*icv)(struct ah_data*,
	                               struct sk_buff *skb, u8 *icv);

	struct crypto_tfm	*tfm;
};

static inline void
ah_hmac_digest_walk(struct crypto_tfm *tfm, struct ah_data *ahp, 
		struct sk_buff *skb)
{
	crypto_hmac_init(tfm, ahp->key, &ahp->key_len);
	skb_icv_walk(skb, tfm, 0, skb->len, crypto_hmac_update);
	crypto_hmac_final(tfm, ahp->key, &ahp->key_len, ahp->work_icv);
}

#if defined(CONFIG_CRYPTO_HW)
static inline int
ah_hmac_digest_sg(struct ah_data *ahp, struct sk_buff *skb)
{
       /* for now we use just first scatterlist element, because ixp4xx driver
	* needs only virtual address */
       //struct scatterlist sgbuf[nfrags > 4 ? 0 : nfrags];
       struct scatterlist sgbuf[1];
       struct scatterlist *sg = sgbuf;

#if 0
       if (unlikely(nfrags > 4)) 
       {
               sg = kmalloc(sizeof(struct scatterlist) * nfrags, GFP_ATOMIC);
               if (!sg)
                       return -ENOMEM;
       }
#endif

       skb_to_sgvec(skb, sg, 0, skb->len);
       crypto_hmac(ahp->tfm, ahp->key, &ahp->key_len, sg, 1, ahp->work_icv);

#if 0
       if (unlikely(sg != sgbuf))
               kfree(sg);
#endif

       return 0;
}
#endif /* CONFIG_CRYPTO_HW */

static inline void
ah_hmac_digest(struct ah_data *ahp, struct sk_buff *skb, 
		u8 *auth_data)
{
	struct crypto_tfm *tfm = ahp->tfm;

	memset(auth_data, 0, ahp->icv_trunc_len);
#if defined(CONFIG_CRYPTO_HW)  
       if (unlikely(ah_hmac_digest_sg(ahp, skb)))
#endif 
	       ah_hmac_digest_walk(tfm, ahp, skb);
	memcpy(auth_data, ahp->work_icv, ahp->icv_trunc_len);
}

#endif
