ifndef build_install_directory
$(warning build_install_directory is not defined - will use ./ROOT directory!)
build_install_directory := ./ROOT
endif

instdir := ${build_install_directory}
fakeroot := fakeroot
_TAR := tar --preserve --numeric-owner -m
_TARCMD := ${fakeroot} $(_TAR) --atime-preserve -xf -
_TARCF := ${fakeroot} $(_TAR) -cf -
_STARCMD := sudo $(_TAR) --atime-preserve -xf -
_STARCF := sudo $(_TAR) -cf -


TOOLS := ${BUILDDIR}/tools
TOOLDIR := ${TOOLS}/bin
MKSQUASHFS := ${TOOLDIR}/mksquashfs
MKFWIMAGE := ${TOOLDIR}/mkfwimage
MKFWIMAGE_HOME := ${BUILDDIR}/apps/gpl/mkfwimage

REVISION := $(shell ./get-revision.sh)
TIMESTAMP := $(shell date +%y%m%d.%H%M)
FULL_VERSION := ${PRODUCT_VERSION}.${REVISION}.${TIMESTAMP}
VERSION_FILE := ${instdir}/usr/lib/version
VER := $(shell cat ${VERSION_FILE})
VER_pS := PICO${NONAME}
LATEST_LINK := $(PRODUCT_VERSION).latest

