#!/bin/sh

if [ $# -eq 1 ];
	then img=$1
	else img=squashfs.img
fi

if [ -z $BUILDDIR ]
	then BUILDDIR=..
fi
TOOLS=${BUILDDIR}/tools
TOOLDIR=${TOOLS}/bin
MKSQUASHFS=${TOOLDIR}/mksquashfs

if [ -z "${stagingdir}" ]; then
	echo "stagingdir is undefined!"
	exit 1
fi;
rm -rf ${stagingdir}/dev
mkdir -p ${stagingdir}/dev
# updates timestamp for web files
rm -f ${stagingdir}/__romfs.meta
find ${stagingdir} | xargs touch -c
# finally make the image
${MKSQUASHFS} ${stagingdir} $img -be -all-root -noappend
chmod 755 $img

