#!/bin/sh
if [ $# -eq 1 -o $# -eq 2 ]; then SL_TIME=$1; else SL_TIME=4; fi
if [ $# -eq 2 ]; then WLAN_IFC="$2"; else WLAN_IFC=ath0; fi
/sbin/wlanconfig survey0 create wlandev wifi0 wlanmode sta nosbeacon >/dev/null
oldchan=`/sbin/iwgetid -fr ${WLAN_IFC}`
/bin/ifconfig survey0 up && sleep $SL_TIME
/sbin/iwlist survey0 scan | /sbin/scanparser
/bin/ifconfig survey0 down
/sbin/wlanconfig survey0 destroy
newchan=`/sbin/iwgetid -fr ${WLAN_IFC}`
if [ ".${oldchan}" != ".${newchan}" ]; then 
	/sbin/iwconfig ${WLAN_IFC} chan ${oldchan}
else
	/sbin/iwpriv ${WLAN_IFC} hide_ssid `iwpriv ${WLAN_IFC} get_hide_ssid | cut -f 2 -d ":"`
fi
