// WIAClient.h

#ifndef _WIACLIENT_H
#define _WIACLIENT_H

//#define WIACLIENT_TRACE_ON

#define WIACLIENT_ERR_NONE true
#define WIACLIENT_NO_VALUE -9999

#include <stdio.h>
#include <winsock.h>
#pragma comment(lib,"ws2_32.lib")

#define BUFJPEG_LENGTH 20000

typedef struct wiaclient_data_t
{
	int jpeg_stream_len;
	BYTE jpeg_stream_data[BUFJPEG_LENGTH];
} wiaclient_data;

class WIAClient
{
private:
	wiaclient_data data;
	void ResetWIAClient_data();
	void ClearRcvbuf();
	bool FeedRcvbuf( );
	bool FindInRcvbuf( BYTE car);
	bool FindNextInRcvbuf(BYTE car );
	bool FindSOIHeader();
	bool FindEOIHeader();
	bool ToJpegbuf(int ircvbuf);
public:
	WIAClient();
	~WIAClient();
	bool Connect(int prtNo, char* ipAddress);
	void Disconnect( );
	void GetWIAClientData( wiaclient_data *new_data);
	bool StartWIAStreaming( );
	int GetWIANextFrame( wiaclient_data *new_data);
};

#endif