// WifibotProducerSMCPPEXE.cpp: dfinit le point d'entre pour l'application console.
//

#include "stdafx.h"


int _tmain(int argc, char* argv[])
{
   char *prm1;
   int index_sm;
   pthread_t thread_wifibotproducer;
   pthread_t thread_wifibotproducer_clavier;
   void *ret_wifibotproducer;

   if (argc == 1)
   {
	  //sprintf(remote_ip, "%s", DEFAULT_WIACLIENT_IP);
	  //tcp_port = DEFAULT_WIACLIENT_TCP_PORT;
	   printf("--> Loading Wifibot config file: %s\n", WIFIBOT_CONFIG_FILE);
	   if (!ReadWifibotConfigFile( WIFIBOT_CONFIG_FILE))
	   {
		   return 0;
	   }
	   
   }
   else if (argc == 2)
   {
	   printf("--> Loading Wifibot config file: %s\n", (argv[1]));
	   if (!ReadWifibotConfigFile( argv[1]))
	   {
		   return 0;
	   }
   }
   else
   {
	   printf("Wrong number of arguments.");
	   return 0;
   }

   printf("Initializing Wifibot streaming on IP %s, port %d...\n", wifibot_remote_ip, wifibot_tcp_port);
   if ((index_sm=WifibotStartProduce( wifibot_tcp_port, wifibot_remote_ip )) == -1)
	   return 0;
   printf("Starting Wifibot streaming!\n");

  pthread_mutex_init (&wifibotproducer_mutex, NULL);

  if (pthread_create (&thread_wifibotproducer, NULL, WifibotProducerUpdate, NULL) < 0) {
    fprintf (stderr, "pthread_create error for thread  WifibotClientProducerUpdate\n");
    exit (1);
  }

   if (pthread_create (&thread_wifibotproducer_clavier, NULL, WifibotGestionClavier, NULL) < 0) {
    fprintf (stderr, "pthread_create error for thread  WIAClientProducerUpdate\n");
    exit (1);
  }

  (void)pthread_join (thread_wifibotproducer, &ret_wifibotproducer);

   stop_shared_memory(index_sm);
   
   return 0;

}

