#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <tchar.h>
#pragma comment(lib, "user32.lib")
#include "WifibotSMCPP.h"

extern "C" {

/*
// Structure de donnes  associer  la mmoire partage
*/
#include "WifibotSM_info.h"

static WifibotLibObjects *shared_data; // Pointeur vers la mmoire partage pour la structure WifibotLibObjects
static WifibotLibObjects old_shared_data;
static int wifibot_sm_index=-1;
static bool first_time_access;
static bool is_shared_memory_already_initialized=false;

  //---------------------------------------------

  int create_wifibot_sm()
  {
	  wifibot_sm_index = create_shared_memory(WIFIBOT_SM_NAME, sizeof(WifibotLibObjects) );
	  return wifibot_sm_index;
  }

  //----------------------------------------

  int attach_wifibot_sm()
  {
	  wifibot_sm_index = init_shared_memory(WIFIBOT_SM_NAME, (void **)&shared_data);
	  return wifibot_sm_index;
  }

  //----------------------------------------

  int copy_wifibot_data_to_sm(WifibotLibObjects *wifibot_data)
  {
	  if (wifibot_sm_index == -1)
		  return -1;
	  copy_data_to_shared_memory(wifibot_sm_index, (const void *)wifibot_data, sizeof(WifibotLibObjects) );
	  return wifibot_sm_index;
  }


  //----------------------------------------

   bool is_wifibot_connected()
   {
	   return shared_data->is_wifibot_connected;
   }

  //----------------------------------------

   void reset_wifibot_connected()
   {
	   shared_data->is_wifibot_connected = false;
   }

  //----------------------------------------

   int get_wifibot_batVoltage()
   {
	   return shared_data->data.batVoltage;
   }

   //----------------------------------------

   int get_wifibot_speedFrontLeft()
   {
	   return shared_data->data.speedFrontLeft;
   }

   //----------------------------------------

   int get_wifibot_speedFrontRight()
   {
	   return shared_data->data.speedFrontRight;
   }

   //----------------------------------------

   int get_wifibot_speedRearLeft()
   {
	   return shared_data->data.speedRearLeft;
   }

   //----------------------------------------

   int get_wifibot_speedRearRight()
   {
	   return shared_data->data.speedRearRight;
   }
   
   //----------------------------------------

   int get_wifibot_irLeft()
   {
	   return shared_data->data.irLeft;
   }

   //----------------------------------------

   int get_wifibot_irRight()
   {
	   return shared_data->data.irRight;
   }

   //----------------------------------------

   int get_wifibot_irLeft2()
   {
	   return shared_data->data.irLeft2;
   }

   //----------------------------------------

   int get_wifibot_irRight2()
   {
	   return shared_data->data.irRight2;
   }

  //----------------------------------------

   long get_wifibot_odometryLeft()
   {
	   return shared_data->data.odometryLeft;
   }

  //----------------------------------------

   long get_wifibot_odometryRight()
   {
	   return shared_data->data.odometryRight;
   }

  //----------------------------------------

   int get_wifibot_left_speed()
   {
	   return shared_data->data.leftSpeed;
   }

   //----------------------------------------

   int get_wifibot_right_speed()
   {
	   return shared_data->data.rightSpeed;
   }

   //----------------------------------------

   void set_wifibot_speed(int newLeftSpeed, int newRightSpeed)
   {
	   shared_data->data.leftSpeed = newLeftSpeed;
	   shared_data->data.rightSpeed = newRightSpeed;
   }

  //----------------------------------------
   
   long get_wifibot_frame_id()
   {
	   if ( !is_wifibot_connected()) 
 	      return NO_VALID_FRAME;

	   return shared_data->id;
   }

   //----------------------------------------

   int get_wifibot_frame_sec( double *sec)
   {
	   if ( !is_wifibot_connected())
	   {
		   *sec = NULL;
 	      return NO_VALID_FRAME;
	   }

	   *sec = shared_data->sec;
	
	   return VALID_FRAME_OK;
   }

   //----------------------------------------

}