// clientWIASMconsole.cpp: dfinit le point d'entre pour l'application console.
//

#include "stdafx.h"
#include "clientWIASMconsoleCPP.h"
#include <ijl.h>
#include <opencv2/core/core.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <iostream>

using namespace cv;
using namespace std;

static pthread_mutex_t wiaclientreader_mutex;

JPEG_CORE_PROPERTIES jpeg;
BYTE jpegtemp[300000];
static int width;
static int height;

//-----------------------------------------------

int WIAClientStartRead(int width_in, int height_in )
{
	int index_sm;
	int aux;

	if ((index_sm = attach_wiaclient_sm()) < 0)
	   return -1;

	if (aux = ijlInit(&jpeg) != 0)
	{
		printf("IjlInit() erreur %d\n", aux);
		return -1;
	}
    jpeg.JPGFile = NULL;

	width = width_in;
	height = height_in;
	return index_sm;
}

//-----------------------------------------------

void *WIAClientReader(void *args)
{
	double sec;
	unsigned long new_frame_id;
	unsigned long old_frame_id;
	FILE *f;
	static wiaclient_data new_data;
	BYTE *aux_jpeg_data;
	int len_jpeg;
	char jpeg_fic[200];
	int aux;
	Mat image(height, width, CV_8UC3);
   old_frame_id = get_wiaclient_frame_id();
   while (1)
   {
	new_frame_id = get_wiaclient_frame_id();
	if (is_wiaclient_connected() == true && (new_frame_id != old_frame_id) && (new_frame_id != NO_VALID_FRAME))
	{
	  get_wiaclient_frame_sec( &sec);
#ifdef WIACLIENT_TRACE_ON
	  printf("num frame: %lu, Time (s): %1.3lf, (%d octets)\n", get_wiaclient_frame_id(), sec, get_jpeg_length());
#endif
	  len_jpeg = get_jpeg_length();
	  copy_jpeg_data(&new_data);
	  sprintf(jpeg_fic,"tmp/img%d.jpg", get_wiaclient_frame_id());

	  jpeg.JPGBytes= new_data.jpeg_stream_data;
	  
	  jpeg.JPGSizeBytes=len_jpeg;//+posend+2;
	
		if(( aux = ijlRead(&jpeg, IJL_JBUFF_READPARAMS))==0)
		{
			jpeg.JPGColor = IJL_YCBCR;
			// Set up the info on the desired DIB properties.
			jpeg.DIBColor = IJL_BGR;
			jpeg.DIBChannels = 3;
			jpeg.DIBWidth = jpeg.JPGWidth;
			jpeg.DIBHeight = -jpeg.JPGHeight;
			jpeg.DIBPadBytes = 0;
			jpeg.DIBBytes = jpegtemp;
			jpeg.JPGFile = jpeg_fic;
			
			// Now get the actual JPEG image data into the pixel buffer.
			if (aux = ijlRead(&jpeg, IJL_JBUFF_READWHOLEIMAGE) < 0)
			{
#ifdef WIACLIENT_TRACE_ON
				printf("IjlRead() Bis err = %d\n", aux);
#endif
			}
		}
		else
		{
			printf("IjlRead() err = %d\n", aux);
		}
		ijlWrite(&jpeg,IJL_JFILE_WRITEWHOLEIMAGE);
		
		image.data = jpegtemp;
		
        imshow("Image display", image);
		waitKey(20);
		Sleep(5);

	  old_frame_id = new_frame_id;
	}
   }
}

//-----------------------------------------------


int _tmain(int argc, _TCHAR* argv[])
{

	int index_sm;
	pthread_t thread_wiaclientreader;
    void *ret_wiaclientreader;


   if ((index_sm = WIAClientStartRead(320, 240 )) < 0)
	   return 0;
   
  pthread_mutex_init (&wiaclientreader_mutex, NULL);

  if (pthread_create (&thread_wiaclientreader, NULL, WIAClientReader, NULL) < 0) {
    fprintf (stderr, "pthread_create error for thread  WIAClientReader\n");
    exit (1);
  }
 

  (void)pthread_join (thread_wiaclientreader, &ret_wiaclientreader);
   
  return 0;
}

