// clientWifibotSMconsoleCPP.cpp: dfinit le point d'entre pour l'application console.
//

#include "stdafx.h"
#include "clientWifibotSMconsoleCPP.h"

#define WIFIBOT_LOG_FIC "wifibotdata.log"

static pthread_mutex_t wifibotreader_mutex;
//-----------------------------------------------

int WifibotStart(  )
{
	int index_sm;
	index_sm = attach_wifibot_sm();
	return index_sm;
}

//-----------------------------------------------

void *WifibotReader(void *args)
{
	double sec;
	unsigned long new_frame_id;
	unsigned long old_frame_id;
   old_frame_id = get_wifibot_frame_id();
   while (1)
   {
	new_frame_id = get_wifibot_frame_id();
	if (is_wifibot_connected() == true && (new_frame_id != old_frame_id) && (new_frame_id != NO_VALID_FRAME))
	{
	  get_wifibot_frame_sec( &sec);
#ifdef WIFIBOT_TRACE_ON
	  printf("num frame: %lu, Time (s): %1.3lf, irLeft=%d, irRight=%d\n", get_wifibot_frame_id(), sec, get_wifibot_irLeft(), get_wifibot_irRight(), get_wifibot_irLeft2(), get_wifibot_irRight2());
#endif
	}

	old_frame_id = new_frame_id;
   }
}

//-----------------------------------------------

int _tmain(int argc, _TCHAR* argv[])
{
	int index_sm;
	pthread_t thread_wifibotreader;
    void *ret_wifibotreader;

	//pthread_mutex_init (&my_mutex, NULL);
   if (WifibotStart() < 0)
	   return 0;

   pthread_mutex_init (&wifibotreader_mutex, NULL);

  if (pthread_create (&thread_wifibotreader, NULL, WifibotReader, NULL) < 0) {
    fprintf (stderr, "pthread_create error for thread  WIAClientReader\n");
    exit (1);
  }
 

  (void)pthread_join (thread_wifibotreader, &ret_wifibotreader);
	return 0;
}

